/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.service.http.impl.service.server.DecodingException;

public class HttpParser {
    private static final Pattern SPACE_ENTITY_OR_PLUS_SIGN_REGEX = Pattern.compile("%20|\\+");
    private static final String NAME_ATTRIBUTE = "name";

    public static String extractPath(String uri) {
        String path = uri;
        int i = path.indexOf(63);
        if (i > -1) {
            path = path.substring(0, i);
        }
        return path;
    }

    public static String decodePath(String path) throws DecodingException {
        try {
            return URLDecoder.decode(path, StandardCharsets.UTF_8.displayName());
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            throw new DecodingException(String.format("Unable to decode malformed url %s", path), (Throwable)e);
        }
    }

    public static Collection<HttpPart> parseMultipartContent(InputStream content, String contentType) throws IOException {
        MimeMultipart mimeMultipart = null;
        ArrayList parts = Lists.newArrayList();
        try {
            mimeMultipart = new MimeMultipart((DataSource)new ByteArrayDataSource(content, contentType));
        }
        catch (MessagingException e) {
            throw new IOException(e);
        }
        try {
            int partCount = mimeMultipart.getCount();
            for (int i = 0; i < partCount; ++i) {
                String[] contentIdHeader;
                String contentDisposition;
                String filename;
                BodyPart part = mimeMultipart.getBodyPart(i);
                String partName = filename = part.getFileName();
                String[] contentDispositions = part.getHeader("Content-Disposition");
                if (contentDispositions != null && (contentDisposition = contentDispositions[0]).contains(NAME_ATTRIBUTE)) {
                    partName = contentDisposition.substring(contentDisposition.indexOf(NAME_ATTRIBUTE) + NAME_ATTRIBUTE.length() + 2);
                    partName = partName.substring(0, partName.indexOf("\""));
                }
                if (partName == null && mimeMultipart.getContentType().contains(MediaType.MULTIPART_RELATED.toString()) && (contentIdHeader = part.getHeader("Content-Id")) != null && contentIdHeader.length > 0) {
                    partName = contentIdHeader[0];
                }
                HttpPart httpPart = new HttpPart(partName, filename, IOUtils.toByteArray((InputStream)part.getInputStream()), part.getContentType(), part.getSize());
                Enumeration headers = part.getAllHeaders();
                while (headers.hasMoreElements()) {
                    Header header = (Header)headers.nextElement();
                    httpPart.addHeader(header.getName(), header.getValue());
                }
                parts.add(httpPart);
            }
        }
        catch (MessagingException e) {
            throw new IOException(e);
        }
        return parts;
    }

    public static String normalizePathWithSpacesOrEncodedSpaces(String path) {
        return SPACE_ENTITY_OR_PLUS_SIGN_REGEX.matcher(path).replaceAll(" ");
    }
}

