/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.execution.ExecutionContext;
import org.mule.runtime.core.internal.execution.ExecutionInterceptor;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;

public class CommitTransactionInterceptor
implements ExecutionInterceptor<CoreEvent> {
    private final ExecutionInterceptor<CoreEvent> nextInterceptor;

    public CommitTransactionInterceptor(ExecutionInterceptor<CoreEvent> nextInterceptor) {
        this.nextInterceptor = nextInterceptor;
    }

    @Override
    public CoreEvent execute(ExecutionCallback<CoreEvent> callback, ExecutionContext executionContext) throws Exception {
        CoreEvent result = this.nextInterceptor.execute(callback, executionContext);
        if (executionContext.needsTransactionResolution()) {
            try {
                TransactionCoordination.getInstance().resolveTransaction();
            }
            catch (Exception e) {
                if (result == null) {
                    result = PrivilegedEvent.getCurrentEvent();
                }
                throw new MessagingException(result, (Throwable)e);
            }
        }
        return result;
    }
}

