/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.util.InfrastructureParameterBuilder;
import org.mule.runtime.extension.internal.property.NoReconnectionStrategyModelProperty;

public final class ReconnectionStrategyDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ExtensionDeclaration declaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
        if (!declaration.getModelProperty(NoReconnectionStrategyModelProperty.class).isPresent()) {
            new IdempotentDeclarationWalker(){

                @Override
                protected void onSource(SourceDeclaration declaration) {
                    this.addReconnectionIfRequired(declaration);
                }

                @Override
                protected void onOperation(OperationDeclaration declaration) {
                    this.addReconnectionIfRequired(declaration);
                }

                private void addReconnectionIfRequired(ExecutableComponentDeclaration declaration) {
                    if (declaration.isRequiresConnection()) {
                        InfrastructureParameterBuilder.addReconnectionStrategyParameter(declaration);
                    }
                }
            }.walk(declaration);
        }
    }
}

