/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.property;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.extension.internal.value.ValueProviderFactory;

public final class ValueProviderFactoryModelProperty
implements ModelProperty {
    private final Field connectionField;
    private final Field configField;
    private final Class<? extends ValueProvider> valuesProvider;
    private final List<InjectableParameterInfo> injectableParameters;

    private ValueProviderFactoryModelProperty(Class<? extends ValueProvider> valueProvider, List<InjectableParameterInfo> injectableParameters, Field connectionField, Field configField) {
        Preconditions.checkNotNull(valueProvider, "Values Provider Class parameter can't be null");
        Preconditions.checkNotNull(injectableParameters, "injectableParameters parameter can't be null");
        this.valuesProvider = valueProvider;
        this.injectableParameters = injectableParameters;
        this.connectionField = connectionField;
        this.configField = configField;
    }

    public static ValueProviderFactoryModelPropertyBuilder builder(Class<? extends ValueProvider> valuesProvider) {
        return new ValueProviderFactoryModelPropertyBuilder(valuesProvider);
    }

    @Override
    public String getName() {
        return "ValueProviderFactory";
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    public Class<? extends ValueProvider> getValueProvider() {
        return this.valuesProvider;
    }

    public List<String> getRequiredParameters() {
        return this.injectableParameters.stream().map(InjectableParameterInfo::getParameterName).collect(Collectors.toList());
    }

    public List<InjectableParameterInfo> getInjectableParameters() {
        return this.injectableParameters;
    }

    public boolean usesConnection() {
        return this.connectionField != null;
    }

    public boolean usesConfig() {
        return this.configField != null;
    }

    public ValueProviderFactory createFactory(ParameterValueResolver parameterValueResolver, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier, ReflectionCache reflectionCache, MuleContext muleContext) {
        return new ValueProviderFactory(this, parameterValueResolver, connectionSupplier, configurationSupplier, this.connectionField, this.configField, reflectionCache, muleContext);
    }

    public static class InjectableParameterInfo {
        String parameterName;
        MetadataType type;
        boolean required;

        InjectableParameterInfo(String parameterName, MetadataType type, boolean required) {
            this.parameterName = parameterName;
            this.type = type;
            this.required = required;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public MetadataType getType() {
            return this.type;
        }

        public void setType(MetadataType type) {
            this.type = type;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }
    }

    public static class ValueProviderFactoryModelPropertyBuilder {
        private final Class<? extends ValueProvider> dynamicOptionsResolver;
        private final List<InjectableParameterInfo> injectableParameters;
        private Field connectionField;
        private Field configField;

        ValueProviderFactoryModelPropertyBuilder(Class<? extends ValueProvider> dynamicOptionsResolver) {
            this.dynamicOptionsResolver = dynamicOptionsResolver;
            this.injectableParameters = new ArrayList<InjectableParameterInfo>();
        }

        public ValueProviderFactoryModelPropertyBuilder withInjectableParameter(String name, MetadataType metadataType, boolean isRequired) {
            this.injectableParameters.add(new InjectableParameterInfo(name, metadataType, isRequired));
            return this;
        }

        public ValueProviderFactoryModelProperty build() {
            return new ValueProviderFactoryModelProperty(this.dynamicOptionsResolver, this.injectableParameters, this.connectionField, this.configField);
        }

        public void withConnection(Field connectionField) {
            this.connectionField = connectionField;
        }

        public void withConfig(Field configField) {
            this.configField = configField;
        }
    }
}

