/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type.annotation;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.stereotype.StereotypeDefinition;

public class StereotypeTypeAnnotation
implements TypeAnnotation {
    public static final String NAME = "stereotype";
    private List<StereotypeModel> allowedStereotypes;
    private transient List<Class<? extends StereotypeDefinition>> definitionClasses;

    public static StereotypeTypeAnnotation fromDefinitions(List<Class<? extends StereotypeDefinition>> definitionClasses) {
        StereotypeTypeAnnotation annotation = new StereotypeTypeAnnotation(new ArrayList<StereotypeModel>(definitionClasses.size()));
        annotation.definitionClasses = definitionClasses;
        return annotation;
    }

    public StereotypeTypeAnnotation(List<StereotypeModel> allowedStereotypes) {
        this.allowedStereotypes = allowedStereotypes;
    }

    public List<StereotypeModel> getAllowedStereotypes() {
        return this.allowedStereotypes;
    }

    public void resolveStereotypes(Function<Class<? extends StereotypeDefinition>, StereotypeModel> resolver) {
        Preconditions.checkState(this.allowedStereotypes.isEmpty(), "The stereotypes have already been resolved or provided");
        this.definitionClasses.forEach(clazz -> this.allowedStereotypes.add((StereotypeModel)resolver.apply((Class<? extends StereotypeDefinition>)clazz)));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isPublic() {
        return true;
    }
}

