/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.interpreted.module;

import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.mule.weave.v2.interpreted.module.WeaveDataFormat;
import org.mule.weave.v2.interpreted.module.WeaveWriter$;
import org.mule.weave.v2.interpreted.module.WeaveWriterSettings;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ArraySeq;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.NameSeq;
import org.mule.weave.v2.model.structure.NameValuePair;
import org.mule.weave.v2.model.structure.Namespace;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.structure.schema.SchemaProperty;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.FunctionType$;
import org.mule.weave.v2.model.types.LocalDateTimeType$;
import org.mule.weave.v2.model.types.LocalDateType$;
import org.mule.weave.v2.model.types.LocalTimeType$;
import org.mule.weave.v2.model.types.NamespaceType$;
import org.mule.weave.v2.model.types.NullType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.PeriodType$;
import org.mule.weave.v2.model.types.RangeType$;
import org.mule.weave.v2.model.types.RegexType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.TimeType$;
import org.mule.weave.v2.model.types.TimeZoneType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.values.FunctionParameter;
import org.mule.weave.v2.model.values.FunctionValue;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.helper.AttributeHelper$;
import org.mule.weave.v2.module.ConfigurableReaderWriter;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.writer.BufferedIOWriter;
import org.mule.weave.v2.module.writer.BufferedIOWriter$;
import org.mule.weave.v2.module.writer.TargetProvider;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import org.mule.weave.v2.utils.StringEscapeHelper$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IndexedSeqOptimized;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t\u001dg\u0001B\u0001\u0003\u0001=\u00111bV3bm\u0016<&/\u001b;fe*\u00111\u0001B\u0001\u0007[>$W\u000f\\3\u000b\u0005\u00151\u0011aC5oi\u0016\u0014\bO]3uK\u0012T!a\u0002\u0005\u0002\u0005Y\u0014$BA\u0005\u000b\u0003\u00159X-\u0019<f\u0015\tYA\"\u0001\u0003nk2,'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/mi\u0011\u0001\u0007\u0006\u00033i\taa\u001e:ji\u0016\u0014(BA\u0002\u0007\u0013\ta\u0002D\u0001\u0004Xe&$XM\u001d\u0005\t=\u0001\u0011\t\u0011)A\u0005?\u0005\u0011qn\u001d\t\u0003A\u0015j\u0011!\t\u0006\u0003E\r\n!![8\u000b\u0003\u0011\nAA[1wC&\u0011a%\t\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\tQ\u0001\u0011)\u0019!C\u0001S\u0005A1/\u001a;uS:<7/F\u0001+!\tYC&D\u0001\u0003\u0013\ti#AA\nXK\u00064Xm\u0016:ji\u0016\u00148+\u001a;uS:<7\u000f\u0003\u00050\u0001\t\u0005\t\u0015!\u0003+\u0003%\u0019X\r\u001e;j]\u001e\u001c\b\u0005\u0003\u00052\u0001\t\u0005\t\u0015a\u00033\u0003\r\u0019G\u000f\u001f\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0019\tQ!\\8eK2L!a\u000e\u001b\u0003#\u00153\u0018\r\\;bi&|gnQ8oi\u0016DH\u000fC\u0003:\u0001\u0011\u0005!(\u0001\u0004=S:LGO\u0010\u000b\u0004wyzDC\u0001\u001f>!\tY\u0003\u0001C\u00032q\u0001\u000f!\u0007C\u0003\u001fq\u0001\u0007q\u0004C\u0003)q\u0001\u0007!\u0006\u0003\u0005\u001a\u0001!\u0015\r\u0011\"\u0003B+\u0005\u0011\u0005CA\fD\u0013\t!\u0005D\u0001\tCk\u001a4WM]3e\u0013>;&/\u001b;fe\"9a\t\u0001b\u0001\n\u00139\u0015A\u00033fG2\f'/\u001a3OgV\t\u0001\nE\u0002J\u001dBk\u0011A\u0013\u0006\u0003\u00172\u000bq!\\;uC\ndWM\u0003\u0002N%\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005=S%!B*uC\u000e\\\u0007cA%R'&\u0011!K\u0013\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0002U/6\tQK\u0003\u0002Wi\u0005I1\u000f\u001e:vGR,(/Z\u0005\u00031V\u0013\u0011BT1nKN\u0004\u0018mY3\t\ri\u0003\u0001\u0015!\u0003I\u0003-!Wm\u00197be\u0016$gj\u001d\u0011\t\u000fq\u0003\u0001\u0019!C\u0005;\u0006a\u0011N\\:jI\u0016DU-\u00193feV\ta\f\u0005\u0002\u0012?&\u0011\u0001M\u0005\u0002\b\u0005>|G.Z1o\u0011\u001d\u0011\u0007\u00011A\u0005\n\r\f\u0001#\u001b8tS\u0012,\u0007*Z1eKJ|F%Z9\u0015\u0005\u0011<\u0007CA\tf\u0013\t1'C\u0001\u0003V]&$\bb\u00025b\u0003\u0003\u0005\rAX\u0001\u0004q\u0012\n\u0004B\u00026\u0001A\u0003&a,A\u0007j]NLG-\u001a%fC\u0012,'\u000f\t\u0005\bY\u0002\u0001\r\u0011\"\u0003n\u0003\u0019Ig\u000eZ3oiV\ta\u000e\u0005\u0002\u0012_&\u0011\u0001O\u0005\u0002\u0004\u0013:$\bb\u0002:\u0001\u0001\u0004%Ia]\u0001\u000bS:$WM\u001c;`I\u0015\fHC\u00013u\u0011\u001dA\u0017/!AA\u00029DaA\u001e\u0001!B\u0013q\u0017aB5oI\u0016tG\u000f\t\u0005\u0006q\u0002!\t%_\u0001\u0006G2|7/\u001a\u000b\u0002I\")1\u0010\u0001C\u0001s\u0006AAm\\%oI\u0016tG\u000fC\u0003~\u0001\u0011\u0005\u00110\u0001\u0005e_\u0012+G-\u001a8u\u0011\u0019y\b\u0001\"\u0011\u0002\u0002\u0005i1\u000f^1si\u0012{7-^7f]R$2\u0001ZA\u0002\u0011\u001d\t)A a\u0001\u0003\u000f\t\u0001\u0002\\8dCRLwN\u001c\t\u0005\u0003\u0013\t\t\"\u0004\u0002\u0002\f)!\u0011QAA\u0007\u0015\r\tyAB\u0001\u0007a\u0006\u00148/\u001a:\n\t\u0005M\u00111\u0002\u0002\u0010\u0019>\u001c\u0017\r^5p]\u000e\u000b\u0007/\u00192mK\"1\u0011q\u0003\u0001\u0005\u0002e\fQc\u001d;beRDU-\u00193fe&3'+Z9vSJ,G\rC\u0004\u0002\u001c\u0001!\t%!\b\u0002\u001f\u0011,g-\u001b8f\u001d\u0006lWm\u001d9bG\u0016$r\u0001ZA\u0010\u0003C\tY\u0004\u0003\u0005\u0002\u0006\u0005e\u0001\u0019AA\u0004\u0011!\t\u0019#!\u0007A\u0002\u0005\u0015\u0012A\u00029sK\u001aL\u0007\u0010\u0005\u0003\u0002(\u0005Ub\u0002BA\u0015\u0003c\u00012!a\u000b\u0013\u001b\t\tiCC\u0002\u000209\ta\u0001\u0010:p_Rt\u0014bAA\u001a%\u00051\u0001K]3eK\u001aLA!a\u000e\u0002:\t11\u000b\u001e:j]\u001eT1!a\r\u0013\u0011!\ti$!\u0007A\u0002\u0005\u0015\u0012aA;sS\"9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0013\u0001D4fiB\u0013XMZ5y\r>\u0014HCBA\u0013\u0003\u000b\n9\u0005\u0003\u0005\u0002$\u0005}\u0002\u0019AA\u0013\u0011!\ti$a\u0010A\u0002\u0005\u0015\u0002bBA&\u0001\u0011%\u0011QJ\u0001\u000foJLG/\u001a(b[\u0016\u001c\b/Y2f)\u0015!\u0017qJA)\u0011!\t\u0019#!\u0013A\u0002\u0005\u0015\u0002\u0002CA\u001f\u0003\u0013\u0002\r!!\n\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X\u0005y1\u000f^1si\u0006#HO]5ckR,7\u000fF\u0002e\u00033B\u0001\"!\u0002\u0002T\u0001\u0007\u0011q\u0001\u0005\b\u0003;\u0002A\u0011BA0\u00035)g\u000eZ!uiJL'-\u001e;fgR\u0019A-!\u0019\t\u0011\u0005\u0015\u00111\fa\u0001\u0003\u000fAq!!\u001a\u0001\t\u0013\t9'A\u0006ti\u0006\u0014Ho\u00142kK\u000e$HCAA5)\r!\u00171\u000e\u0005\u0007c\u0005\r\u00049\u0001\u001a\t\r\u0005=\u0004\u0001\"\u0003z\u0003%)g\u000eZ(cU\u0016\u001cG\u000fC\u0004\u0002t\u0001!I!!\u001e\u0002\u0015M$\u0018M\u001d;BeJ\f\u0017\u0010\u0006\u0003\u0002x\u0005mDc\u00013\u0002z!1\u0011'!\u001dA\u0004IB\u0001\"!\u0002\u0002r\u0001\u0007\u0011q\u0001\u0005\b\u0003\u007f\u0002A\u0011BAA\u0003!)g\u000eZ!se\u0006LHc\u00013\u0002\u0004\"A\u0011QAA?\u0001\u0004\t9\u0001C\u0004\u0002\b\u0002!\t!!#\u0002\u001dI,\u0017/^5sKN\fVo\u001c;fgR\u0019a,a#\t\u0011\u00055\u0015Q\u0011a\u0001\u0003K\t1a[3z\u0011\u0019\t\t\n\u0001C\u0005s\u00069a.Z<mS:,\u0007bBAK\u0001\u0011\u0005\u0013qS\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0016\u0003}Aq!a'\u0001\t\u0003\ti*A\u0006xe&$XmU2iK6\fGCBAP\u0003G\u000b\u0019\fF\u0002e\u0003CCa!MAM\u0001\b\u0011\u0004\u0002CAS\u00033\u0003\r!a*\u0002\u0003Q\u0004B!!+\u000206\u0011\u00111\u0016\u0006\u0004\u0003[#\u0014!\u0002;za\u0016\u001c\u0018\u0002BAY\u0003W\u0013A\u0001V=qK\"A\u0011QWAM\u0001\u0004\t9,\u0001\u0004tG\",W.\u0019\t\u0006#\u0005e\u0016QX\u0005\u0004\u0003w\u0013\"AB(qi&|g\u000e\u0005\u0003\u0002@\u0006\rWBAAa\u0015\r\t),V\u0005\u0005\u0003\u000b\f\tM\u0001\u0004TG\",W.\u0019\u0005\b\u0003\u0013\u0004A\u0011AAf\u00035\tX/\u00197jM&,GMT1nKR1\u0011QZAi\u0003K$2\u0001ZAh\u0011\u0019\t\u0014q\u0019a\u0002e!A\u0011QRAd\u0001\u0004\t\u0019\u000e\u0005\u0004\u0002V\u0006m\u0017q\\\u0007\u0003\u0003/T1!!75\u0003\u00191\u0018\r\\;fg&!\u0011Q\\Al\u0005\u00151\u0016\r\\;f!\r!\u0016\u0011]\u0005\u0004\u0003G,&!D)vC2Lg-[3e\u001d\u0006lW\r\u0003\u0005\u0002h\u0006\u001d\u0007\u0019AAu\u0003)\tG\u000f\u001e:jEV$Xm\u001d\t\u0006#\u0005e\u00161\u001e\t\u0007\u0003+\fY.!<\u0011\u0007Q\u000by/C\u0002\u0002rV\u0013qAT1nKN+\u0017\u000fC\u0004\u0002v\u0002!\t!a>\u0002\u001d\u0005d'/Z1es\u0012+g-\u001b8fIR\u0019a,!?\t\u000f\u0005m\u00181\u001fa\u0001'\u0006\u0011an\u001d\u0005\u0007\u0003\u007f\u0004A\u0011A=\u0002A]\u0014\u0018\u000e^3E_\u000e,X.\u001a8u'\u0016\u0004\u0018M]1u_JLeMU3rk&\u0014X\r\u001a\u0005\b\u0005\u0007\u0001A\u0011\u000bB\u0003\u00031!wn\u0016:ji\u00164\u0016\r\\;f)\u0011\u00119Aa\u0003\u0015\u0007\u0011\u0014I\u0001\u0003\u00042\u0005\u0003\u0001\u001dA\r\u0005\t\u0005\u001b\u0011\t\u00011\u0001\u0003\u0010\u0005\ta\u000f\r\u0003\u0003\u0012\t]\u0001CBAk\u00037\u0014\u0019\u0002\u0005\u0003\u0003\u0016\t]A\u0002\u0001\u0003\r\u00053\u0011Y!!A\u0001\u0002\u000b\u0005!1\u0004\u0002\u0004?\u0012\n\u0014\u0003\u0002B\u000f\u0005G\u00012!\u0005B\u0010\u0013\r\u0011\tC\u0005\u0002\b\u001d>$\b.\u001b8h!\r\t\"QE\u0005\u0004\u0005O\u0011\"aA!os\"9!1\u0006\u0001\u0005\n\t5\u0012aD4fiVs\u0017.];f!J,g-\u001b=\u0015\t\u0005\u0015\"q\u0006\u0005\b\u0005c\u0011I\u00031\u0001T\u0003%q\u0017-\\3ta\u0006\u001cW\rC\u0004\u00036\u0001!IAa\u000e\u0002\u0015%\u001cH)\u0019;f)f\u0004X\r\u0006\u0003\u0003:\tuBc\u00010\u0003<!1\u0011Ga\rA\u0004IB\u0001\"!*\u00034\u0001\u0007\u0011q\u0015\u0005\b\u0005\u0003\u0002A\u0011\u0002B\"\u0003M\u0019w\u000e\u001c7fGR,f\u000eZ3dY\u0006\u0014X\r\u001a(T)\u0011\u0011)E!\u0015\u0015\t\t\u001d#q\n\t\u0006\u0005\u0013\u0012YeU\u0007\u0002\u0019&\u0019!Q\n'\u0003\u0007M+\u0017\u000f\u0003\u00042\u0005\u007f\u0001\u001dA\r\u0005\t\u0005'\u0012y\u00041\u0001\u0003V\u0005Qa/\u00197vKB\u000b\u0017N]:\u0011\r\t]#\u0011\rB3\u001d\u0011\u0011IF!\u0018\u000f\t\u0005-\"1L\u0005\u0002'%\u0019!q\f\n\u0002\u000fA\f7m[1hK&!!Q\nB2\u0015\r\u0011yF\u0005\t\u0004)\n\u001d\u0014b\u0001B5+\na1*Z=WC2,X\rU1je\"9!Q\u000e\u0001\u0005\n\t=\u0014\u0001E<sSR,\u0017+^8uKN#(/\u001b8h)\r!'\u0011\u000f\u0005\t\u0005g\u0012Y\u00071\u0001\u0002&\u0005A1\u000f\u001e:WC2,X\r\u0003\u0004\u0003x\u0001!\t%_\u0001\u0006M2,8\u000f\u001b\u0005\b\u0005w\u0002A\u0011\tB?\u0003)!\u0017\r^1G_Jl\u0017\r^\u000b\u0003\u0005\u007f\u0002R!EA]\u0005\u0003\u0003dAa!\u0003\u000e\nM\u0005\u0003\u0003BC\u0005\u000f\u0013YI!%\u000e\u0003iI1A!#\u001b\u0005)!\u0015\r^1G_Jl\u0017\r\u001e\t\u0005\u0005+\u0011i\t\u0002\u0007\u0003\u0010\ne\u0014\u0011!A\u0001\u0006\u0003\u0011YBA\u0002`IM\u0002BA!\u0006\u0003\u0014\u0012a!Q\u0013B=\u0003\u0003\u0005\tQ!\u0001\u0003\u001c\t\u0019q\f\n\u001b\b\u000f\te%\u0001#\u0001\u0003\u001c\u0006Yq+Z1wK^\u0013\u0018\u000e^3s!\rY#Q\u0014\u0004\u0007\u0003\tA\tAa(\u0014\u0007\tu\u0005\u0003C\u0004:\u0005;#\tAa)\u0015\u0005\tm\u0005\u0002\u0003BT\u0005;#\tA!+\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\t-&q\u0016B])\ra$Q\u0016\u0005\u0007c\t\u0015\u00069\u0001\u001a\t\u0011\tE&Q\u0015a\u0001\u0005g\u000b!\u0001\u001e9\u0011\u0007]\u0011),C\u0002\u00038b\u0011a\u0002V1sO\u0016$\bK]8wS\u0012,'\u000f\u0003\u0004)\u0005K\u0003\rA\u000b\u0005\t\u0005O\u0013i\n\"\u0001\u0003>R1!q\u0018Bb\u0005\u000b$2\u0001\u0010Ba\u0011\u0019\t$1\u0018a\u0002e!1aDa/A\u0002}Aa\u0001\u000bB^\u0001\u0004Q\u0003")
public class WeaveWriter
implements Writer {
    private BufferedIOWriter writer;
    private final OutputStream os;
    private final WeaveWriterSettings settings;
    private final Stack<ArrayBuffer<Namespace>> declaredNs;
    private boolean insideHeader;
    private int indent;
    private volatile boolean bitmap$0;

    public static WeaveWriter apply(OutputStream outputStream, WeaveWriterSettings weaveWriterSettings, EvaluationContext evaluationContext) {
        return WeaveWriter$.MODULE$.apply(outputStream, weaveWriterSettings, evaluationContext);
    }

    public static WeaveWriter apply(TargetProvider targetProvider, WeaveWriterSettings weaveWriterSettings, EvaluationContext evaluationContext) {
        return WeaveWriter$.MODULE$.apply(targetProvider, weaveWriterSettings, evaluationContext);
    }

    @Override
    public final void writeValue(Value<?> value, EvaluationContext ctx) {
        Writer.writeValue$(this, value, ctx);
    }

    @Override
    public String getName() {
        return Writer.getName$(this);
    }

    @Override
    public final void endDocument(LocationCapable location) {
        Writer.endDocument$(this, location);
    }

    @Override
    public void doEndDocument(LocationCapable location) {
        Writer.doEndDocument$(this, location);
    }

    @Override
    public void setOption(Location location, String optionName, Object value) {
        ConfigurableReaderWriter.setOption$(this, location, optionName, value);
    }

    @Override
    public WeaveWriterSettings settings() {
        return this.settings;
    }

    private BufferedIOWriter writer$lzycompute() {
        WeaveWriter weaveWriter = this;
        synchronized (weaveWriter) {
            if (!this.bitmap$0) {
                this.writer = BufferedIOWriter$.MODULE$.apply(this.os, StandardCharsets.UTF_8, this.settings().bufferSize());
                this.bitmap$0 = true;
            }
        }
        return this.writer;
    }

    private BufferedIOWriter writer() {
        return !this.bitmap$0 ? this.writer$lzycompute() : this.writer;
    }

    private Stack<ArrayBuffer<Namespace>> declaredNs() {
        return this.declaredNs;
    }

    private boolean insideHeader() {
        return this.insideHeader;
    }

    private void insideHeader_$eq(boolean x$1) {
        this.insideHeader = x$1;
    }

    private int indent() {
        return this.indent;
    }

    private void indent_$eq(int x$1) {
        this.indent = x$1;
    }

    @Override
    public void close() {
        this.writer().close();
    }

    public void doIndent() {
        this.indent_$eq(this.indent() + 1);
    }

    public void doDedent() {
        this.indent_$eq(this.indent() - 1);
    }

    @Override
    public void startDocument(LocationCapable location) {
        this.declaredNs().push((Object)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
    }

    public void startHeaderIfRequired() {
        block0: {
            if (this.insideHeader()) break block0;
            this.writer().write("%dw 2.0");
            this.newline();
            this.insideHeader_$eq(true);
        }
    }

    @Override
    public void defineNamespace(LocationCapable location, String prefix, String uri) {
        this.startHeaderIfRequired();
        this.writeNamespace(prefix, uri);
    }

    public String getPrefixFor(String prefix, String uri) {
        String string;
        Option mayBeNamespace = ((TraversableLike)this.declaredNs().toStream().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (ArrayBuffer)x$1.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)WeaveWriter.$anonfun$getPrefixFor$2(uri, x$2))), Stream$.MODULE$.canBuildFrom())).headOption();
        Option option = mayBeNamespace;
        if (option instanceof Some) {
            Some some = (Some)option;
            Namespace value = (Namespace)some.value();
            string = value.prefix();
        } else if (None$.MODULE$.equals(option)) {
            String resultPrefix = prefix;
            if (prefix.isEmpty()) {
                resultPrefix = new StringBuilder(2).append("ns").append(((SeqLike)this.declaredNs().top()).size()).toString();
            }
            boolean alreadyDefined = true;
            int i = 0;
            ObjectRef tmpPrefix = ObjectRef.create((Object)resultPrefix);
            while (alreadyDefined) {
                if (((IndexedSeqOptimized)this.declaredNs().top()).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)WeaveWriter.$anonfun$getPrefixFor$3(tmpPrefix, x$3)))) {
                    tmpPrefix.elem = new StringBuilder(0).append(resultPrefix).append(i).toString();
                } else {
                    alreadyDefined = false;
                    resultPrefix = (String)tmpPrefix.elem;
                }
                ++i;
            }
            string = resultPrefix;
        } else {
            throw new MatchError((Object)option);
        }
        return string;
    }

    private void writeNamespace(String prefix, String uri) {
        block0: {
            if (((IndexedSeqOptimized)this.declaredNs().top()).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)WeaveWriter.$anonfun$writeNamespace$1(prefix, x$4)))) break block0;
            this.writer().write("ns ");
            this.writer().write(prefix);
            this.writer().write(" ");
            this.writer().write(uri);
            ((ArrayBuffer)this.declaredNs().top()).$plus$eq((Object)new Namespace(prefix, uri));
            this.newline();
        }
    }

    private void startAttributes(LocationCapable location) {
        this.writer().write(" @(");
    }

    private void endAttributes(LocationCapable location) {
        this.writer().write(")");
    }

    private void startObject(EvaluationContext ctx) {
        this.writer().write("{");
        this.doIndent();
        this.newline();
    }

    private void endObject() {
        this.doDedent();
        this.newline();
        this.writer().write("}");
    }

    private void startArray(LocationCapable location, EvaluationContext ctx) {
        this.writer().write("[");
        this.doIndent();
        this.newline();
    }

    private void endArray(LocationCapable location) {
        this.doDedent();
        this.newline();
        this.writer().write("]");
    }

    public boolean requiresQuotes(String key) {
        return StringEscapeHelper$.MODULE$.keyRequiresQuotes(key);
    }

    private void newline() {
        block1: {
            if (this.settings().indent().length() <= 0) break block1;
            this.writer().write("\n");
            if (this.indent() > 0) {
                this.writer().write(new StringOps(Predef$.MODULE$.augmentString(this.settings().indent())).$times(this.indent()));
            }
        }
    }

    @Override
    public OutputStream result() {
        this.writer().flush();
        return this.os;
    }

    public void writeSchema(Type t, Option<Schema> schema, EvaluationContext ctx) {
        Some some;
        Schema theSchema;
        Option<Schema> option = schema;
        if (option instanceof Some && (theSchema = (Schema)(some = (Some)option).value()).properties(ctx).nonEmpty()) {
            this.writer().write(" as ");
            this.writer().write(t.name());
            this.writer().write(" {");
            BooleanRef first = BooleanRef.create((boolean)true);
            theSchema.properties(ctx).foreach((Function1 & Serializable & scala.Serializable)sproperty -> {
                WeaveWriter.$anonfun$writeSchema$1(this, ctx, first, sproperty);
                return BoxedUnit.UNIT;
            });
            this.writer().write("}");
            this.writer().flush();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void qualifiedName(Value<QualifiedName> key, Option<Value<NameSeq>> attributes, EvaluationContext ctx) {
        QualifiedName evaluate = key.evaluate(ctx);
        Option<Namespace> option = evaluate.namespace();
        if (option instanceof Some) {
            Some some = (Some)option;
            Namespace ns = (Namespace)some.value();
            this.writer().write(new StringBuilder(1).append(this.getUniquePrefix(ns)).append("#").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        if (this.requiresQuotes(evaluate.name())) {
            this.writeQuoteString(evaluate.name());
        } else {
            this.writer().write(evaluate.name());
        }
        Option<Value<NameSeq>> option2 = attributes;
        if (option2 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option2;
            Value attrs = (Value)some.value();
            NameSeq attributes2 = (NameSeq)attrs.evaluate(ctx);
            if (!attributes2.isEmpty()) {
                this.startAttributes(attrs);
                BooleanRef first = BooleanRef.create((boolean)true);
                attributes2.toIterator().foreach((Function1 & Serializable & scala.Serializable)nvp -> {
                    WeaveWriter.$anonfun$qualifiedName$1(this, ctx, first, nvp);
                    return BoxedUnit.UNIT;
                });
                this.endAttributes(attrs);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option2)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option2);
        }
    }

    public boolean alreadyDefined(Namespace ns) {
        return this.declaredNs().exists((Function1 & Serializable & scala.Serializable)context -> BoxesRunTime.boxToBoolean((boolean)context.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)WeaveWriter.$anonfun$alreadyDefined$2(ns$1, x$5)))));
    }

    public void writeDocumentSeparatorIfRequired() {
        block0: {
            if (!this.insideHeader()) break block0;
            this.writer().write("---");
            this.newline();
            this.insideHeader_$eq(false);
        }
    }

    @Override
    public void doWriteValue(Value<?> v, EvaluationContext ctx) {
        block27: {
            Type type;
            Type type2;
            Type type3;
            Type type4;
            Type type5;
            Type type6;
            Type type7;
            Type type8;
            Type type9;
            Type type10;
            this.writeDocumentSeparatorIfRequired();
            Type type11 = v.valueType(ctx);
            if (type11 != null && (type10 = type11).isInstanceOf(BooleanType$.MODULE$, ctx)) {
                this.writer().write(v.evaluate(ctx).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (type11 != null && (type9 = type11).isInstanceOf(NumberType$.MODULE$, ctx)) {
                this.writer().write(v.evaluate(ctx).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (type11 != null && (type8 = type11).isInstanceOf(NullType$.MODULE$, ctx)) {
                this.writer().write("null");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (type11 != null && (type7 = type11).isInstanceOf(RangeType$.MODULE$, ctx)) {
                this.writeValue(ArrayType$.MODULE$.coerce(v, ctx), ctx);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (type11 != null && (type6 = type11).isInstanceOf(ArrayType$.MODULE$, ctx)) {
                BoxedUnit boxedUnit;
                Iterator iterator = ((ArraySeq)v.evaluate(ctx)).toIterator();
                if (iterator.isEmpty()) {
                    this.writer().write("[]");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.startArray(v, ctx);
                    BooleanRef first = BooleanRef.create((boolean)true);
                    Iterator elements = this.settings().limitCollectionSize() ? iterator.take(this.settings().maxCollectionSize()) : iterator;
                    elements.foreach((Function1 & Serializable & scala.Serializable)v2 -> {
                        WeaveWriter.$anonfun$doWriteValue$1(this, ctx, first, v2);
                        return BoxedUnit.UNIT;
                    });
                    this.endArray(v);
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (type11 != null && (type5 = type11).isInstanceOf(ObjectType$.MODULE$, ctx)) {
                BoxedUnit boxedUnit;
                Seq valuePairs = ((ObjectSeq)v.evaluate(ctx)).toSeq(ctx);
                if (valuePairs.isEmpty()) {
                    this.writer().write("{}");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    Object object;
                    Seq<Namespace> missingNamespace = this.collectUndeclaredNS(valuePairs, ctx);
                    boolean needNSDeclarations = missingNamespace.nonEmpty();
                    if (needNSDeclarations) {
                        this.declaredNs().push((Object)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
                        this.writer().write("do ");
                        this.startObject(ctx);
                        missingNamespace.foreach((Function1 & Serializable & scala.Serializable)namespace -> {
                            this.writeNamespace(this.getUniquePrefix(namespace), namespace.uri());
                            return BoxedUnit.UNIT;
                        });
                        this.writer().write("---");
                        this.newline();
                    }
                    this.startObject(ctx);
                    BooleanRef first = BooleanRef.create((boolean)true);
                    Seq elements = this.settings().limitCollectionSize() ? (Seq)valuePairs.take(this.settings().maxCollectionSize()) : valuePairs;
                    elements.foreach((Function1 & Serializable & scala.Serializable)ekv -> {
                        WeaveWriter.$anonfun$doWriteValue$3(this, ctx, first, ekv);
                        return BoxedUnit.UNIT;
                    });
                    if (needNSDeclarations) {
                        this.endObject();
                        object = this.declaredNs().pop();
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    this.endObject();
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            } else if (type11 != null && (type4 = type11).isInstanceOf(FunctionType$.MODULE$, ctx)) {
                FunctionParameter[] parameters = ((FunctionValue)FunctionType$.MODULE$.coerce(v, ctx)).parameters();
                this.writer().write("(");
                BooleanRef first = BooleanRef.create((boolean)true);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parameters)).foreach((Function1 & Serializable & scala.Serializable)param -> {
                    WeaveWriter.$anonfun$doWriteValue$4(this, first, param);
                    return BoxedUnit.UNIT;
                });
                this.writer().write(") -> ???");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (type11 != null && this.isDateType(type3 = type11, ctx)) {
                this.writer().write("|");
                this.writer().write((String)StringType$.MODULE$.coerce(v, ctx).evaluate(ctx));
                this.writer().write("|");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (type11 != null && (type2 = type11).isInstanceOf(RegexType$.MODULE$, ctx)) {
                this.writer().write("/");
                this.writer().write(((Regex)RegexType$.MODULE$.coerce(v, ctx).evaluate(ctx)).regex());
                this.writer().write("/");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (type11 != null && (type = type11).isInstanceOf(NamespaceType$.MODULE$, ctx)) {
                this.writeValue(ObjectType$.MODULE$.coerce(v, ctx), ctx);
                this.writer().write("as Namespace");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String strValue = (String)StringType$.MODULE$.coerce(v, ctx).evaluate(ctx);
                this.writeQuoteString(strValue);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (this.settings().ignoreSchema()) break block27;
            this.writeSchema(v.valueType(ctx), v.valueType(ctx).schema(ctx), ctx);
        }
    }

    private String getUniquePrefix(Namespace namespace) {
        return this.getPrefixFor(namespace.prefix(), namespace.uri());
    }

    private boolean isDateType(Type t, EvaluationContext ctx) {
        return t.isInstanceOf(DateTimeType$.MODULE$, ctx) || t.isInstanceOf(LocalDateType$.MODULE$, ctx) || t.isInstanceOf(PeriodType$.MODULE$, ctx) || t.isInstanceOf(LocalDateTimeType$.MODULE$, ctx) || t.isInstanceOf(TimeType$.MODULE$, ctx) || t.isInstanceOf(LocalTimeType$.MODULE$, ctx) || t.isInstanceOf(TimeZoneType$.MODULE$, ctx);
    }

    private Seq<Namespace> collectUndeclaredNS(Seq<KeyValuePair> valuePairs, EvaluationContext ctx) {
        return (Seq)((SeqLike)valuePairs.flatMap((Function1 & Serializable & scala.Serializable)kvp -> {
            TraversableOnce traversableOnce;
            Object key = kvp._1();
            QualifiedName keyName = (QualifiedName)key.evaluate(ctx);
            Option<Value<NameSeq>> mayBeAttributes = AttributeHelper$.MODULE$.attributes((Value<?>)key, ctx);
            Option<Value<NameSeq>> option = mayBeAttributes;
            if (option instanceof Some) {
                Some some = (Some)option;
                Value attributes = (Value)some.value();
                traversableOnce = ((NameSeq)attributes.evaluate(ctx)).toIterator().flatMap((Function1 & Serializable & scala.Serializable)nvp -> Option$.MODULE$.option2Iterable(((QualifiedName)nvp._1().evaluate(ctx)).namespace().flatMap((Function1 & Serializable & scala.Serializable)qname -> this.alreadyDefined((Namespace)qname) ? None$.MODULE$ : new Some(qname))));
            } else if (None$.MODULE$.equals(option)) {
                traversableOnce = (TraversableOnce)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            } else {
                throw new MatchError(option);
            }
            TraversableOnce missingAttributesNS = traversableOnce;
            Option missingNS = keyName.namespace().flatMap((Function1 & Serializable & scala.Serializable)qname -> this.alreadyDefined((Namespace)qname) ? None$.MODULE$ : new Some(qname));
            return missingNS.isDefined() ? (TraversableOnce)missingAttributesNS.toSeq().$colon$plus(missingNS.get(), Seq$.MODULE$.canBuildFrom()) : missingAttributesNS;
        }, Seq$.MODULE$.canBuildFrom())).distinct();
    }

    private void writeQuoteString(String strValue) {
        this.writer().write(StringEscapeHelper$.MODULE$.escapeString(strValue));
    }

    @Override
    public void flush() {
        this.writer().flush();
    }

    @Override
    public Option<DataFormat<?, ?>> dataFormat() {
        return new Some((Object)new WeaveDataFormat());
    }

    public static final /* synthetic */ boolean $anonfun$getPrefixFor$2(String uri$1, Namespace x$2) {
        String string = x$2.uri();
        String string2 = uri$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getPrefixFor$3(ObjectRef tmpPrefix$1, Namespace x$3) {
        String string = x$3.prefix();
        String string2 = (String)tmpPrefix$1.elem;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$writeNamespace$1(String prefix$1, Namespace x$4) {
        String string = x$4.prefix();
        String string2 = prefix$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$writeSchema$1(WeaveWriter $this, EvaluationContext ctx$1, BooleanRef first$1, SchemaProperty sproperty) {
        block0: {
            if (sproperty.internal()) break block0;
            Object object = !first$1.elem ? $this.writer().append(", ") : BoxedUnit.UNIT;
            $this.writer().append(sproperty.name().evaluate(ctx$1));
            $this.writer().write(": ");
            $this.writeValue(sproperty.value(), ctx$1);
            first$1.elem = false;
        }
    }

    public static final /* synthetic */ void $anonfun$qualifiedName$1(WeaveWriter $this, EvaluationContext ctx$2, BooleanRef first$2, NameValuePair nvp) {
        if (!first$2.elem) {
            $this.writer().write(", ");
        }
        $this.qualifiedName((Value<QualifiedName>)nvp._1(), (Option<Value<NameSeq>>)None$.MODULE$, ctx$2);
        $this.writer().write(": ");
        $this.writeValue((Value<?>)nvp._2(), ctx$2);
        first$2.elem = false;
    }

    public static final /* synthetic */ boolean $anonfun$alreadyDefined$2(Namespace ns$1, Namespace x$5) {
        String string = x$5.uri();
        String string2 = ns$1.uri();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$doWriteValue$1(WeaveWriter $this, EvaluationContext ctx$3, BooleanRef first$3, Value v2) {
        if (!first$3.elem) {
            $this.writer().write(", ");
            $this.newline();
        }
        $this.writeValue(v2, ctx$3);
        first$3.elem = false;
    }

    public static final /* synthetic */ void $anonfun$doWriteValue$3(WeaveWriter $this, EvaluationContext ctx$3, BooleanRef first$4, KeyValuePair ekv) {
        if (!first$4.elem) {
            $this.writer().write(",");
            $this.newline();
        }
        $this.qualifiedName((Value<QualifiedName>)ekv._1(), AttributeHelper$.MODULE$.attributes((Value<?>)ekv._1(), ctx$3), ctx$3);
        $this.writer().write(": ");
        $this.writeValue((Value<?>)ekv._2(), ctx$3);
        first$4.elem = false;
    }

    public static final /* synthetic */ void $anonfun$doWriteValue$4(WeaveWriter $this, BooleanRef first$5, FunctionParameter param) {
        Object object = !first$5.elem ? $this.writer().append(", ") : BoxedUnit.UNIT;
        $this.writer().write(param.name());
        $this.writer().write(":");
        $this.writer().write(param.wtype().name());
        first$5.elem = false;
    }

    public WeaveWriter(OutputStream os, WeaveWriterSettings settings, EvaluationContext ctx) {
        this.os = os;
        this.settings = settings;
        ConfigurableReaderWriter.$init$(this);
        Writer.$init$(this);
        this.declaredNs = (Stack)Stack$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.insideHeader = false;
        this.indent = 0;
    }
}

