/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ItemSequenceInfo;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.message.GroupCorrelation;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.api.util.CaseInsensitiveHashMap;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.internal.message.DefaultMessageBuilder;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.util.message.ItemSequenceInfoUtils;
import org.mule.runtime.core.privileged.connector.ReplyToHandler;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.DefaultMuleSession;
import org.mule.runtime.core.privileged.event.MuleSession;
import org.mule.runtime.core.privileged.store.DeserializationPostInitialisable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventBuilder
implements InternalEvent.Builder {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMessageBuilder.class);
    private static final int INTERNAL_PARAMETERS_INITIAL_CAPACITY = 4;
    private BaseEventContext context;
    private Function<EventContext, Message> messageFactory;
    private boolean varsModified = false;
    private final CaseInsensitiveHashMap<String, TypedValue<?>> flowVariables = new CaseInsensitiveHashMap();
    private CaseInsensitiveHashMap<String, TypedValue<?>> originalVars;
    private final Map<String, Object> internalParameters;
    private Error error;
    private Optional<ItemSequenceInfo> itemSequenceInfo = Optional.empty();
    private String legacyCorrelationId;
    private MuleSession session;
    private SecurityContext securityContext;
    private InternalEvent originalEvent;
    private boolean modified;
    private boolean notificationsEnabled = true;

    public DefaultEventBuilder(BaseEventContext messageContext) {
        this.context = messageContext;
        this.session = new DefaultMuleSession();
        this.originalVars = CaseInsensitiveHashMap.emptyCaseInsensitiveMap();
        this.internalParameters = new HashMap<String, Object>(4);
    }

    public DefaultEventBuilder(InternalEvent event) {
        this.context = event.getContext();
        this.originalEvent = event;
        this.messageFactory = e -> event.getMessage();
        this.itemSequenceInfo = event.getItemSequenceInfo();
        this.legacyCorrelationId = event.getLegacyCorrelationId();
        this.securityContext = event.getSecurityContext();
        this.session = event.getSession();
        this.error = event.getError().orElse(null);
        this.notificationsEnabled = event.isNotificationsEnabled();
        this.originalVars = (CaseInsensitiveHashMap)event.getVariables();
        this.internalParameters = new HashMap(event.getInternalParameters());
    }

    public DefaultEventBuilder(BaseEventContext messageContext, InternalEvent event) {
        this(event);
        this.context = messageContext;
        this.modified = true;
    }

    @Override
    public DefaultEventBuilder message(Message message) {
        Objects.requireNonNull(message);
        this.messageFactory = e -> message;
        this.modified = true;
        return this;
    }

    @Override
    public InternalEvent.Builder message(Function<EventContext, Message> messageFactory) {
        Objects.requireNonNull(messageFactory);
        this.messageFactory = messageFactory;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder variables(Map<String, ?> flowVariables) {
        this.copyFromTo(flowVariables, this.flowVariables);
        this.varsModified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder variablesTyped(Map<String, TypedValue<?>> variables) {
        if (!(variables instanceof CaseInsensitiveHashMap)) {
            return this.variables((Map)variables);
        }
        if (this.varsModified) {
            this.flowVariables.clear();
        }
        this.originalVars = (CaseInsensitiveHashMap)variables;
        this.varsModified = false;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder addVariable(String key, Object value) {
        this.initVariables();
        this.flowVariables.put(key, new TypedValue<Object>(value, DataType.fromObject(value)));
        this.varsModified = true;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder addVariable(String key, Object value, DataType dataType) {
        this.initVariables();
        this.flowVariables.put(key, new TypedValue<Object>(value, dataType));
        this.varsModified = true;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder removeVariable(String key) {
        this.initVariables();
        this.modified = this.flowVariables.remove(key) != null || this.modified;
        this.varsModified = this.varsModified || this.modified;
        return this;
    }

    @Override
    public InternalEvent.Builder clearVariables() {
        if (!this.flowVariables.isEmpty() || !this.originalVars.isEmpty()) {
            this.varsModified = true;
            this.modified = true;
            this.flowVariables.clear();
        }
        return this;
    }

    @Override
    public DefaultEventBuilder internalParameters(Map<String, ?> internalParameters) {
        this.internalParameters.clear();
        this.internalParameters.putAll(internalParameters);
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder addInternalParameter(String key, Object value) {
        this.internalParameters.put(key, value);
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder removeInternalParameter(String key) {
        this.modified = this.internalParameters.remove(key) != null || this.modified;
        return this;
    }

    @Override
    public DefaultEventBuilder correlationId(String correlationId) {
        this.legacyCorrelationId = correlationId;
        this.modified = true;
        return this;
    }

    @Override
    @Deprecated
    public DefaultEventBuilder groupCorrelation(Optional<GroupCorrelation> correlation) {
        return this.itemSequenceInfo((Optional)Optional.ofNullable(ItemSequenceInfoUtils.fromGroupCorrelation(correlation.orElse(null))));
    }

    @Override
    public DefaultEventBuilder itemSequenceInfo(Optional<ItemSequenceInfo> itemSequenceInfo) {
        this.itemSequenceInfo = itemSequenceInfo;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder error(Error error) {
        this.error = error;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder replyToHandler(ReplyToHandler replyToHandler) {
        return this;
    }

    @Override
    public DefaultEventBuilder replyToDestination(Object replyToDestination) {
        return this;
    }

    @Override
    public DefaultEventBuilder session(MuleSession session) {
        this.session = session;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder securityContext(SecurityContext securityContext) {
        SecurityContext originalValue = this.securityContext;
        this.securityContext = securityContext;
        this.modified = originalValue != securityContext;
        return this;
    }

    @Override
    public DefaultEventBuilder disableNotifications() {
        this.notificationsEnabled = false;
        this.modified = true;
        return this;
    }

    @Override
    public InternalEvent build() {
        if (this.originalEvent != null && !this.modified) {
            return this.originalEvent;
        }
        return new InternalEventImplementation(this.context, Objects.requireNonNull(this.messageFactory.apply(this.context)), this.varsModified ? this.flowVariables : this.originalVars, this.internalParameters, this.session, this.securityContext, this.itemSequenceInfo, this.error, this.legacyCorrelationId, this.notificationsEnabled);
    }

    protected void initVariables() {
        if (!this.varsModified) {
            this.flowVariables.putAll(this.originalVars);
        }
    }

    private void copyFromTo(Map<String, ?> source, Map<String, TypedValue<?>> target) {
        target.clear();
        for (Map.Entry<String, ?> entry : source.entrySet()) {
            if (entry.getValue() instanceof TypedValue) {
                target.put(entry.getKey(), (TypedValue)entry.getValue());
                continue;
            }
            target.put(entry.getKey(), new TypedValue(entry.getValue(), DataType.fromObject(entry.getValue())));
        }
        this.modified = true;
    }

    public static class InternalEventImplementation
    implements InternalEvent,
    DeserializationPostInitialisable {
        private static final long serialVersionUID = 1L;
        private final BaseEventContext context;
        private Message message;
        private final MuleSession session;
        private final SecurityContext securityContext;
        private final boolean notificationsEnabled;
        private final CaseInsensitiveHashMap<String, TypedValue<?>> variables;
        private final String legacyCorrelationId;
        private final Error error;
        private final ItemSequenceInfo itemSequenceInfo;
        private transient Map<String, ?> internalParameters;
        private transient LazyValue<BindingContext> bindingContextBuilder = new LazyValue<Supplier<BindingContext>>(() -> BindingContextUtils.addEventBindings(this, BindingContextUtils.NULL_BINDING_CONTEXT));

        private InternalEventImplementation() {
            this.context = null;
            this.session = null;
            this.securityContext = null;
            this.notificationsEnabled = false;
            this.variables = null;
            this.legacyCorrelationId = null;
            this.error = null;
            this.itemSequenceInfo = null;
            this.internalParameters = new HashMap(4);
        }

        private InternalEventImplementation(BaseEventContext context, Message message, CaseInsensitiveHashMap<String, TypedValue<?>> variables, Map<String, ?> internalParameters, MuleSession session, SecurityContext securityContext, Optional<ItemSequenceInfo> itemSequenceInfo, Error error, String legacyCorrelationId, boolean notificationsEnabled) {
            this.context = context;
            this.session = session;
            this.securityContext = securityContext;
            this.message = message;
            this.variables = variables.toImmutableCaseInsensitiveMap();
            this.internalParameters = internalParameters;
            this.itemSequenceInfo = itemSequenceInfo.orElse(null);
            this.error = error;
            this.legacyCorrelationId = legacyCorrelationId;
            this.notificationsEnabled = notificationsEnabled;
        }

        private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
            is.defaultReadObject();
            this.internalParameters = new HashMap(4);
        }

        @Override
        public BaseEventContext getContext() {
            return this.context;
        }

        @Override
        public Message getMessage() {
            return this.message;
        }

        @Override
        public Optional<Authentication> getAuthentication() {
            if (this.securityContext == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.securityContext.getAuthentication());
        }

        @Override
        public Optional<Error> getError() {
            return Optional.ofNullable(this.error);
        }

        @Override
        public byte[] getMessageAsBytes(MuleContext muleContext) throws MuleException {
            try {
                return (byte[])this.transformMessage(DataType.BYTE_ARRAY, muleContext);
            }
            catch (Exception e) {
                throw new DefaultMuleException(CoreMessages.cannotReadPayloadAsBytes(this.message.getPayload().getValue().getClass().getName()), (Throwable)e);
            }
        }

        @Override
        public Object transformMessage(DataType outputType, MuleContext muleContext) throws MessageTransformerException {
            if (outputType == null) {
                throw new MessageTransformerException(CoreMessages.objectIsNull("outputType"), null, this.message);
            }
            Message transformedMessage = muleContext.getTransformationService().transform(this.message, outputType);
            if (this.message.getPayload().getDataType().isStreamType()) {
                this.setMessage(transformedMessage);
            }
            return transformedMessage.getPayload().getValue();
        }

        @Override
        public String getMessageAsString(MuleContext muleContext) throws MuleException {
            return this.getMessageAsString(this.getMessage().getPayload().getDataType().getMediaType().getCharset().orElse(SystemUtils.getDefaultEncoding(muleContext)), muleContext);
        }

        @Override
        public String getMessageAsString(Charset encoding, MuleContext muleContext) throws MuleException {
            try {
                Message transformedMessage = muleContext.getTransformationService().transform(this.message, DataType.builder().type(String.class).charset(encoding).build());
                if (this.message.getPayload().getDataType().isStreamType()) {
                    this.setMessage(transformedMessage);
                }
                return (String)transformedMessage.getPayload().getValue();
            }
            catch (Exception e) {
                throw new DefaultMuleException(CoreMessages.cannotReadPayloadAsString(this.message.getClass().getName()), (Throwable)e);
            }
        }

        public String toString() {
            return "DefaultMuleEvent{" + System.lineSeparator() + "  context=" + this.context + System.lineSeparator() + "  message=" + this.message + System.lineSeparator() + "  variables=" + this.variables + System.lineSeparator() + "  error=" + this.error + System.lineSeparator() + '}';
        }

        @Override
        public MuleSession getSession() {
            return this.session;
        }

        private void initAfterDeserialisation(MuleContext muleContext) throws MuleException {
            if (this.message instanceof InternalMessage) {
                this.setMessage(this.message);
            }
            this.bindingContextBuilder = new LazyValue<Supplier<BindingContext>>(() -> BindingContextUtils.addEventBindings(this, BindingContextUtils.NULL_BINDING_CONTEXT));
        }

        @Override
        public ReplyToHandler getReplyToHandler() {
            return null;
        }

        @Override
        public Object getReplyToDestination() {
            return null;
        }

        private void setMessage(Message message) {
            this.message = message;
        }

        @Override
        public Map<String, TypedValue<?>> getVariables() {
            return this.variables;
        }

        @Override
        public boolean isNotificationsEnabled() {
            return this.notificationsEnabled;
        }

        @Override
        public FlowCallStack getFlowCallStack() {
            return this.context.getFlowCallStack();
        }

        @Override
        public SecurityContext getSecurityContext() {
            return this.securityContext;
        }

        @Override
        public Map<String, ?> getInternalParameters() {
            return Collections.unmodifiableMap(this.internalParameters);
        }

        @Override
        public <T> T getInternalParameter(String key) {
            return (T)this.internalParameters.get(key);
        }

        @Override
        public Optional<GroupCorrelation> getGroupCorrelation() {
            return Optional.ofNullable(ItemSequenceInfoUtils.toGroupCorrelation(this.itemSequenceInfo));
        }

        @Override
        public Optional<ItemSequenceInfo> getItemSequenceInfo() {
            return Optional.ofNullable(this.itemSequenceInfo);
        }

        @Override
        public String getCorrelationId() {
            return this.legacyCorrelationId != null ? this.legacyCorrelationId : this.getContext().getCorrelationId();
        }

        @Override
        @Deprecated
        public String getLegacyCorrelationId() {
            return this.legacyCorrelationId;
        }

        @Override
        public BindingContext asBindingContext() {
            return this.bindingContextBuilder.get();
        }
    }
}

