/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.registry;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.core.internal.registry.TransformerResolver;
import org.mule.runtime.core.internal.registry.TypeBasedTransformerResolver;
import org.mule.runtime.core.internal.transformer.ResolverException;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.core.privileged.util.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleRegistryHelper
implements MuleRegistry {
    protected transient Logger logger = LoggerFactory.getLogger(MuleRegistryHelper.class);
    private Registry registry;
    protected Map<String, Transformer> exactTransformerCache = new ConcurrentHashMap<String, Transformer>(8);
    protected Map<String, List<Transformer>> transformerListCache = new ConcurrentHashMap<String, List<Transformer>>(8);
    private MuleContext muleContext;
    private final ReadWriteLock transformerResolversLock = new ReentrantReadWriteLock();
    private List<TransformerResolver> transformerResolvers = new ArrayList<TransformerResolver>();
    private final ReadWriteLock transformersLock = new ReentrantReadWriteLock();
    private Map<Object, Object> postProcessedObjects = new HashMap<Object, Object>();
    private Collection<Transformer> transformers = new CopyOnWriteArrayList<Transformer>();

    public MuleRegistryHelper(Registry registry, MuleContext muleContext) {
        this.registry = registry;
        this.muleContext = muleContext;
    }

    @Override
    public void initialise() throws InitialisationException {
    }

    @Override
    public void dispose() {
        this.transformerListCache.clear();
        this.exactTransformerCache.clear();
        this.registry.dispose();
    }

    @Override
    public void fireLifecycle(String phase) throws LifecycleException {
        if ("initialise".equals(phase)) {
            this.registry.initialise();
        } else if ("dispose".equals(phase)) {
            this.registry.dispose();
        } else {
            this.registry.fireLifecycle(phase);
        }
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public Transformer lookupTransformer(String name) {
        return (Transformer)this.registry.lookupObject(name);
    }

    @Override
    public Transformer lookupTransformer(DataType source, DataType result) throws TransformerException {
        String dataTypePairHash = this.getDataTypeSourceResultPairHash(source, result = DataType.builder(result).mediaType(MediaType.ANY).charset((Charset)null).build());
        Transformer cachedTransformer = this.exactTransformerCache.get(dataTypePairHash);
        if (cachedTransformer != null) {
            return cachedTransformer;
        }
        Transformer trans = this.resolveTransformer(source, result);
        if (trans != null) {
            Transformer concurrentlyAddedTransformer = this.exactTransformerCache.putIfAbsent(dataTypePairHash, trans);
            if (concurrentlyAddedTransformer != null) {
                return concurrentlyAddedTransformer;
            }
            return trans;
        }
        throw new TransformerException(CoreMessages.noTransformerFoundForMessage(source, result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Transformer resolveTransformer(DataType source, DataType result) throws TransformerException {
        Lock readLock = this.transformerResolversLock.readLock();
        readLock.lock();
        try {
            for (TransformerResolver resolver : this.transformerResolvers) {
                try {
                    Transformer trans = resolver.resolve(source, result);
                    if (trans == null) continue;
                    Transformer transformer = trans;
                    return transformer;
                }
                catch (ResolverException e) {
                    throw new TransformerException(CoreMessages.noTransformerFoundForMessage(source, result), (Throwable)e);
                    return null;
                }
            }
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Transformer> lookupTransformers(DataType source, DataType result) {
        String dataTypePairHash = this.getDataTypeSourceResultPairHash(source, result = DataType.builder(result).mediaType(MediaType.ANY).charset((Charset)null).build());
        List<Transformer> results = this.transformerListCache.get(dataTypePairHash);
        if (results != null) {
            return results;
        }
        results = new ArrayList<Transformer>(2);
        Lock readLock = this.transformersLock.readLock();
        readLock.lock();
        try {
            for (Transformer transformer : this.transformers) {
                if (!(transformer instanceof Converter) || !result.isCompatibleWith(transformer.getReturnDataType()) || !transformer.isSourceDataTypeSupported(source)) continue;
                results.add(transformer);
            }
        }
        finally {
            readLock.unlock();
        }
        List<Transformer> concurrentlyAddedTransformers = this.transformerListCache.putIfAbsent(dataTypePairHash, results);
        if (concurrentlyAddedTransformers != null) {
            return concurrentlyAddedTransformers;
        }
        return results;
    }

    @Override
    public FlowConstruct lookupFlowConstruct(String name) {
        return (FlowConstruct)this.registry.lookupObject(name);
    }

    @Override
    public Collection<FlowConstruct> lookupFlowConstructs() {
        return this.lookupObjects(FlowConstruct.class);
    }

    @Override
    public boolean isSingleton(String key) {
        return this.registry.isSingleton(key);
    }

    @Override
    public final void registerTransformer(Transformer transformer) throws MuleException {
        this.registerObject(BeanUtils.getName(transformer), transformer, Transformer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTransformerResolvers(Transformer t, TransformerResolver.RegistryAction action) {
        if (t instanceof Converter) {
            Lock transformerResolversReadLock = this.transformerResolversLock.readLock();
            transformerResolversReadLock.lock();
            try {
                for (TransformerResolver resolver : this.transformerResolvers) {
                    resolver.transformerChange(t, action);
                }
            }
            finally {
                transformerResolversReadLock.unlock();
            }
            this.transformerListCache.clear();
            this.exactTransformerCache.clear();
            Lock transformersWriteLock = this.transformersLock.writeLock();
            transformersWriteLock.lock();
            try {
                if (action == TransformerResolver.RegistryAction.ADDED) {
                    this.transformers.add(t);
                } else {
                    this.transformers.remove(t);
                }
            }
            finally {
                transformersWriteLock.unlock();
            }
        }
    }

    @Override
    public void registerFlowConstruct(FlowConstruct flowConstruct) throws MuleException {
        this.registry.registerObject(BeanUtils.getName(flowConstruct), flowConstruct, FlowConstruct.class);
    }

    @Override
    public void unregisterTransformer(String transformerName) throws MuleException {
        Transformer transformer = this.lookupTransformer(transformerName);
        this.notifyTransformerResolvers(transformer, TransformerResolver.RegistryAction.REMOVED);
        this.registry.unregisterObject(transformerName, Transformer.class);
    }

    @Override
    public Object applyProcessorsAndLifecycle(Object object) throws MuleException {
        object = this.applyProcessors(object);
        object = this.applyLifecycle(object);
        return object;
    }

    @Override
    public Object applyProcessors(Object object) throws MuleException {
        return this.muleContext.getInjector().inject(object);
    }

    @Override
    public Object applyLifecycle(Object object) throws MuleException {
        return this.applyLifecycle(object, null);
    }

    @Override
    public Object applyLifecycle(Object object, String phase) throws MuleException {
        return this.registry.applyLifecycle(object, phase);
    }

    @Override
    public void applyLifecycle(Object object, String startPhase, String toPhase) throws MuleException {
        this.registry.applyLifecycle(object, startPhase, toPhase);
    }

    @Override
    public <T> T lookupObject(Class<T> type) throws RegistrationException {
        return this.registry.lookupObject(type);
    }

    @Override
    public <T> T lookupObject(String key) {
        return this.registry.lookupObject(key);
    }

    @Override
    public <T> T lookupObject(String key, boolean applyLifecycle) {
        return this.registry.lookupObject(key, applyLifecycle);
    }

    @Override
    public <T> Collection<T> lookupObjects(Class<T> type) {
        return this.registry.lookupObjects(type);
    }

    @Override
    public <T> Collection<T> lookupLocalObjects(Class<T> type) {
        return this.registry.lookupLocalObjects(type);
    }

    @Override
    public <T> Collection<T> lookupObjectsForLifecycle(Class<T> type) {
        return this.registry.lookupObjectsForLifecycle(type);
    }

    @Override
    public <T> T get(String key) {
        return this.registry.get(key);
    }

    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.registry.lookupByType(type);
    }

    @Override
    public void registerObject(String key, Object value, Object metadata) throws RegistrationException {
        this.registry.registerObject(key, value, metadata);
        this.postObjectRegistrationActions(value);
    }

    public void postObjectRegistrationActions(Object value) {
        if (!this.postProcessedObjects.containsKey(value)) {
            this.postProcessedObjects.put(value, value);
            if (value instanceof TransformerResolver) {
                this.registerTransformerResolver((TransformerResolver)value);
            }
            if (value instanceof Converter) {
                this.notifyTransformerResolvers((Converter)value, TransformerResolver.RegistryAction.ADDED);
            }
        }
    }

    @Override
    public void registerObject(String key, Object value) throws RegistrationException {
        this.registry.registerObject(key, value);
        this.postObjectRegistrationActions(value);
    }

    public void registerTransformerResolver(TransformerResolver value) {
        Lock lock = this.transformerResolversLock.writeLock();
        lock.lock();
        try {
            this.transformerResolvers.add(value);
            Collections.sort(this.transformerResolvers, new TransformerResolverComparator());
        }
        finally {
            lock.unlock();
        }
    }

    public void registerObjects(Map objects) throws RegistrationException {
        this.registry.registerObjects(objects);
        for (Object value : objects.values()) {
            this.postObjectRegistrationActions(value);
        }
    }

    @Override
    public Object unregisterObject(String key, Object metadata) throws RegistrationException {
        return this.registry.unregisterObject(key, metadata);
    }

    @Override
    public Object unregisterObject(String key) throws RegistrationException {
        return this.registry.unregisterObject(key);
    }

    @Override
    public String getRegistryId() {
        return this.toString();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    private String getDataTypeSourceResultPairHash(DataType source, DataType result) {
        return source.getClass().getName() + source.hashCode() + ":" + result.getClass().getName() + result.hashCode();
    }

    public Registry getDelegate() {
        return this.registry;
    }

    private class TransformerResolverComparator
    implements Comparator<TransformerResolver> {
        private TransformerResolverComparator() {
        }

        @Override
        public int compare(TransformerResolver transformerResolver, TransformerResolver transformerResolver1) {
            if (transformerResolver.getClass().equals(TypeBasedTransformerResolver.class)) {
                return 1;
            }
            if (transformerResolver1.getClass().equals(TypeBasedTransformerResolver.class)) {
                return -1;
            }
            return 0;
        }
    }
}

