/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.extension.api.annotation.ConfigReferences;
import org.mule.runtime.extension.api.annotation.param.reference.ConfigReference;
import org.mule.runtime.extension.api.annotation.param.reference.FlowReference;
import org.mule.runtime.extension.api.annotation.param.reference.ObjectStoreReference;
import org.mule.runtime.extension.api.annotation.param.stereotype.AllowedStereotypes;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.stereotype.StereotypeDefinition;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.stereotypes.StereotypeResolver;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;

public final class ParameterAllowedStereotypesDeclarionEnricher
extends AbstractAnnotatedDeclarationEnricher {
    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new Enricher().enrich((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }

    private static class Enricher {
        private Map<StereotypeDefinition, StereotypeModel> stereotypesCache = new HashMap<StereotypeDefinition, StereotypeModel>();
        private String defaultNamespace;

        private Enricher() {
        }

        void enrich(ExtensionDeclaration extension) {
            this.defaultNamespace = extension.getXmlDslModel().getPrefix().toUpperCase();
            new IdempotentDeclarationWalker(){

                @Override
                protected void onParameter(ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
                    declaration.getModelProperty(ImplementingParameterModelProperty.class).ifPresent(param -> declaration.setAllowedStereotypeModels(this.getStereotypes(param.getParameter())));
                    declaration.getModelProperty(DeclaringMemberModelProperty.class).ifPresent(field -> declaration.setAllowedStereotypeModels(this.getStereotypes(field.getDeclaringField())));
                }
            }.walk(extension);
        }

        private List<StereotypeModel> getStereotypes(AnnotatedElement element) {
            ConfigReferences references = element.getAnnotation(ConfigReferences.class);
            if (references != null) {
                return Arrays.stream(references.value()).map(ref -> StereotypeModelBuilder.newStereotype(ref.name(), ref.namespace()).withParent(MuleStereotypes.CONFIG).build()).collect(Collectors.toList());
            }
            ConfigReference ref2 = element.getAnnotation(ConfigReference.class);
            if (ref2 != null) {
                return Collections.singletonList(StereotypeModelBuilder.newStereotype(ref2.name(), ref2.namespace()).withParent(MuleStereotypes.CONFIG).build());
            }
            if (element.getAnnotation(FlowReference.class) != null) {
                return Collections.singletonList(MuleStereotypes.FLOW);
            }
            if (element.getAnnotation(ObjectStoreReference.class) != null) {
                return Collections.singletonList(MuleStereotypes.OBJECT_STORE);
            }
            AllowedStereotypes allowedStereotypes = element.getAnnotation(AllowedStereotypes.class);
            if (allowedStereotypes != null) {
                return Arrays.stream(allowedStereotypes.value()).map(definition -> StereotypeResolver.createCustomStereotype(definition, this.defaultNamespace, this.stereotypesCache)).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
    }
}

