/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.config.internal.BeanDependencyResolver;
import org.mule.runtime.config.internal.DefaultBeanDependencyResolver;
import org.mule.runtime.config.internal.ObjectProviderAwareBeanFactory;
import org.mule.runtime.config.internal.ReadOnlyRegistrationDelegate;
import org.mule.runtime.config.internal.RegistrationDelegate;
import org.mule.runtime.config.internal.SpringRegistryLifecycleManager;
import org.mule.runtime.config.internal.dsl.model.ConfigurationDependencyResolver;
import org.mule.runtime.config.internal.factories.ConstantFactoryBean;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleManager;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;
import org.mule.runtime.core.internal.registry.AbstractRegistry;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

public class SpringRegistry
extends AbstractRegistry
implements Injector {
    public static final String REGISTRY_ID = "org.mule.Registry.Spring";
    public static final String SPRING_APPLICATION_CONTEXT = "springApplicationContext";
    private BeanDependencyResolver beanDependencyResolver;
    protected ApplicationContext applicationContext;
    private boolean readOnly;
    private RegistrationDelegate registrationDelegate;
    protected AtomicBoolean springContextInitialised = new AtomicBoolean(false);
    private final Map<String, BeanDefinition> registeredBeanDefinitionsBeforeInitialization = new HashMap<String, BeanDefinition>();

    public SpringRegistry(ApplicationContext applicationContext, MuleContext muleContext, ConfigurationDependencyResolver dependencyResolver, LifecycleInterceptor lifecycleInterceptor) {
        super(REGISTRY_ID, muleContext, lifecycleInterceptor);
        this.setApplicationContext(applicationContext);
        this.beanDependencyResolver = new DefaultBeanDependencyResolver(dependencyResolver, this);
    }

    private void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.readOnly = false;
            this.registrationDelegate = new ConfigurableRegistrationDelegate((ConfigurableApplicationContext)applicationContext);
        } else {
            this.readOnly = true;
            this.registrationDelegate = new ReadOnlyRegistrationDelegate();
        }
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        ((AbstractApplicationContext)this.applicationContext).addBeanFactoryPostProcessor((BeanFactoryPostProcessor)this.createBeforeInitialisationRegisteredObjectsPostProcessor());
        this.springContextInitialised.set(true);
        if (!this.readOnly) {
            ((ConfigurableApplicationContext)this.applicationContext).refresh();
        }
    }

    private BeanDefinitionRegistryPostProcessor createBeforeInitialisationRegisteredObjectsPostProcessor() {
        return new BeanDefinitionRegistryPostProcessor(){

            public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
                SpringRegistry.this.registeredBeanDefinitionsBeforeInitialization.entrySet().stream().forEach(beanDefinitionEntry -> registry.registerBeanDefinition((String)beanDefinitionEntry.getKey(), (BeanDefinition)beanDefinitionEntry.getValue()));
            }

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            }
        };
    }

    @Override
    public void doDispose() {
        if (!this.springContextInitialised.get()) {
            return;
        }
        if (!this.isReadOnly() && ((ConfigurableApplicationContext)this.applicationContext).isActive()) {
            ((ConfigurableApplicationContext)this.applicationContext).close();
        }
        this.applicationContext = null;
        this.springContextInitialised.set(false);
    }

    @Override
    protected LifecycleManager createLifecycleManager(LifecycleInterceptor lifecycleInterceptor) {
        return new SpringRegistryLifecycleManager(this.getRegistryId(), this, this.muleContext, lifecycleInterceptor);
    }

    @Override
    public <T> T lookupObject(String key) {
        try {
            return (T)this.lookupObject(key, true);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public Object lookupObject(String key, boolean applyLifecycle) {
        Object object;
        if (StringUtils.isBlank(key)) {
            this.logger.warn(I18nMessageFactory.createStaticMessage("Detected a lookup attempt with an empty or null key").getMessage(), new Throwable().fillInStackTrace());
            return null;
        }
        if (key.equals(SPRING_APPLICATION_CONTEXT) && this.applicationContext != null) {
            return this.applicationContext;
        }
        try {
            object = this.applicationContext.getBean(key);
        }
        catch (NoSuchBeanDefinitionException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
        this.applyLifecycleIfPrototype(object, key, applyLifecycle);
        return object;
    }

    private void applyLifecycleIfPrototype(Object object, String key, boolean applyLifecycle) {
        if (applyLifecycle && !this.isSingleton(key)) {
            try {
                this.getLifecycleManager().applyCompletedPhases(object);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not apply lifecycle into prototype object " + key), (Throwable)e);
            }
        }
    }

    @Override
    public <T> Collection<T> lookupObjects(Class<T> type) {
        return this.lookupByType(type).values();
    }

    @Override
    public <T> Collection<T> lookupLocalObjects(Class<T> type) {
        return this.internalLookupByTypeWithoutAncestorsAndObjectProviders(type, true, true).values();
    }

    @Override
    public <T> Collection<T> lookupObjectsForLifecycle(Class<T> type) {
        return this.lookupEntriesForLifecycle(type).values();
    }

    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.internalLookupByType(type, true, true);
    }

    @Override
    public boolean isSingleton(String key) {
        return this.applicationContext.isSingleton(key);
    }

    @Override
    public void registerObject(String key, Object value) throws RegistrationException {
        this.registrationDelegate.registerObject(key, value);
    }

    @Override
    public void registerObject(String key, Object value, Object metadata) throws RegistrationException {
        this.registrationDelegate.registerObject(key, value, metadata);
    }

    @Override
    public void registerObjects(Map<String, Object> objects) throws RegistrationException {
        this.registrationDelegate.registerObjects(objects);
    }

    @Override
    protected Object doUnregisterObject(String key) throws RegistrationException {
        return this.registrationDelegate.unregisterObject(key);
    }

    @Override
    public Object applyLifecycle(Object object) throws MuleException {
        LifecycleManager lifecycleManager = this.getLifecycleManager();
        lifecycleManager.applyCompletedPhases(object);
        if (lifecycleManager.getExecutingPhase() != null) {
            lifecycleManager.applyPhase(object, lifecycleManager.getCurrentPhase(), lifecycleManager.getExecutingPhase());
        }
        return object;
    }

    @Override
    public Object applyLifecycle(Object object, String phase) throws MuleException {
        if (phase == null) {
            this.getLifecycleManager().applyCompletedPhases(object);
        } else {
            this.getLifecycleManager().applyPhase(object, "not in lifecycle", phase);
        }
        return object;
    }

    @Override
    public void applyLifecycle(Object object, String startPhase, String toPhase) throws MuleException {
        this.getLifecycleManager().applyPhase(object, startPhase, toPhase);
    }

    @Override
    public <T> T inject(T object) {
        try {
            return this.initialiseObject((ConfigurableApplicationContext)this.applicationContext, "", object);
        }
        catch (LifecycleException e) {
            throw new MuleRuntimeException(e);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(new LifecycleException(e, object));
        }
    }

    private <T> T initialiseObject(ConfigurableApplicationContext applicationContext, String key, T object) throws LifecycleException {
        applicationContext.getBeanFactory().autowireBean(object);
        Object initialised = applicationContext.getBeanFactory().initializeBean(object, key);
        return (T)initialised;
    }

    protected <T> Map<String, T> internalLookupByType(Class<T> type, boolean nonSingletons, boolean eagerInit) {
        try {
            Map beans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, type, (boolean)nonSingletons, (boolean)eagerInit);
            if (nonSingletons && eagerInit) {
                beans.forEach((key, value) -> this.applyLifecycleIfPrototype(value, (String)key, true));
            }
            return beans;
        }
        catch (FatalBeanException fbex) {
            String message = String.format("Failed to lookup beans of type %s from the Spring registry", type);
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(message), (Throwable)fbex);
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    protected <T> Map<String, T> internalLookupByTypeWithoutAncestorsAndObjectProviders(Class<T> type, boolean nonSingletons, boolean eagerInit) {
        try {
            Map<String, T> beans = ((ObjectProviderAwareBeanFactory)this.applicationContext.getAutowireCapableBeanFactory()).getBeansOfTypeWithObjectProviderObjects(type, nonSingletons, eagerInit);
            if (nonSingletons && eagerInit) {
                beans.forEach((key, value) -> this.applyLifecycleIfPrototype(value, (String)key, true));
            }
            return beans;
        }
        catch (FatalBeanException fbex) {
            String message = String.format("Failed to lookup beans of type %s from the Spring registry", type);
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(message), (Throwable)fbex);
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(e.getMessage(), (Throwable)e);
            }
            return Collections.emptyMap();
        }
    }

    public <T> Map<String, T> lookupEntriesForLifecycle(Class<T> type) {
        return this.internalLookupByTypeWithoutAncestorsAndObjectProviders(type, false, false);
    }

    public Map<String, Object> getDependencies(String key) {
        if (!this.readOnly) {
            HashMap<String, Object> dependents = new HashMap<String, Object>();
            for (String dependentKey : ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory().getDependenciesForBean(key)) {
                boolean isBeanDefinition = ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory().containsBeanDefinition(dependentKey);
                if (!isBeanDefinition || !this.applicationContext.isSingleton(dependentKey)) continue;
                dependents.put(dependentKey, this.get(dependentKey));
            }
            return dependents;
        }
        throw new UnsupportedOperationException("This operation is only available when this registry is backed by a ConfigurableApplicationContext");
    }

    public BeanDependencyResolver getBeanDependencyResolver() {
        return this.beanDependencyResolver;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    private class ConfigurableRegistrationDelegate
    implements RegistrationDelegate {
        private final ConfigurableApplicationContext applicationContext;

        private ConfigurableRegistrationDelegate(ConfigurableApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        @Override
        public void registerObject(String key, Object value) throws RegistrationException {
            try {
                SpringRegistry.this.muleContext.withLifecycleLock(() -> this.doRegisterObject(key, value));
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RegistrationException) {
                    throw (RegistrationException)cause;
                }
                throw new RegistrationException(cause);
            }
        }

        @Override
        public void registerObject(String key, Object value, Object metadata) throws RegistrationException {
            this.registerObject(key, value);
        }

        @Override
        public void registerObjects(Map<String, Object> objects) throws RegistrationException {
            if (objects == null || objects.isEmpty()) {
                return;
            }
            for (Map.Entry<String, Object> entry : objects.entrySet()) {
                this.registerObject(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object unregisterObject(String key) throws RegistrationException {
            Object object = this.applicationContext.getBean(key);
            if (this.applicationContext.getBeanFactory().containsBeanDefinition(key)) {
                ((BeanDefinitionRegistry)this.applicationContext.getBeanFactory()).removeBeanDefinition(key);
            }
            ((DefaultListableBeanFactory)this.applicationContext.getBeanFactory()).destroySingleton(key);
            return object;
        }

        private void doRegisterObject(String key, Object value) throws RegistrationException {
            if (SpringRegistry.this.springContextInitialised.get()) {
                if (this.applicationContext.containsBean(key)) {
                    if (SpringRegistry.this.logger.isWarnEnabled()) {
                        SpringRegistry.this.logger.warn(String.format("Spring registry already contains an object named '%s'. The previous object will be overwritten.", key));
                    }
                    SpringRegistry.this.unregisterObject(key);
                }
                try {
                    value = SpringRegistry.this.initialiseObject(this.applicationContext, key, value);
                    SpringRegistry.this.applyLifecycle(value);
                    this.applicationContext.getBeanFactory().registerSingleton(key, value);
                }
                catch (Exception e) {
                    throw new RegistrationException(I18nMessageFactory.createStaticMessage("Could not register object for key " + key), (Throwable)e);
                }
            } else {
                SpringRegistry.this.registeredBeanDefinitionsBeforeInitialization.put(key, BeanDefinitionBuilder.genericBeanDefinition(ConstantFactoryBean.class).addConstructorArgValue(value).getBeanDefinition());
            }
        }
    }
}

