/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.notification.ConnectorMessageNotification;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.NotificationHelper;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.execution.MessageProcessPhase;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.execution.MessageProcessTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NotificationFiringProcessingPhase<Template extends MessageProcessTemplate>
implements MessageProcessPhase<Template>,
Comparable<MessageProcessPhase> {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private NotificationHelper notificationHelper;
    protected MuleContext muleContext;

    protected void fireNotification(Component source, CoreEvent event, FlowConstruct flow, int action) {
        try {
            if (event == null && (event = PrivilegedEvent.getCurrentEvent()) == null) {
                return;
            }
            this.notificationHelper.fireNotification(source, event, flow.getLocation(), action);
        }
        catch (Exception e) {
            this.logger.warn("Could not fire notification. Action: " + action, (Throwable)e);
        }
    }

    @Inject
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        this.notificationHelper = new NotificationHelper(this.muleContext.getNotificationManager(), ConnectorMessageNotification.class, false);
    }
}

