/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.processor.util.InvokerMessageProcessorUtil;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.core.privileged.transformer.ExtendedTransformationService;
import org.mule.runtime.core.privileged.transformer.TransformerTemplate;
import org.mule.runtime.core.privileged.util.TemplateParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokerMessageProcessor
extends AbstractComponent
implements Processor,
Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvokerMessageProcessor.class);
    protected Object object;
    protected Class<?> objectType;
    protected String methodName;
    protected List<?> arguments = new ArrayList();
    protected Class<?>[] argumentTypes;
    protected String name;
    protected TemplateParser.PatternInfo patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    protected Method method;
    protected ExtendedExpressionManager expressionManager;
    @Inject
    protected MuleContext muleContext;

    @Override
    public void initialise() throws InitialisationException {
        if (this.object == null) {
            this.lookupObjectInstance();
        }
        this.resolveMethodToInvoke();
        this.expressionManager = this.muleContext.getExpressionManager();
    }

    protected void resolveMethodToInvoke() throws InitialisationException {
        if (this.argumentTypes != null) {
            this.method = ClassUtils.getMethod(this.object.getClass(), this.methodName, this.argumentTypes);
            if (this.method == null) {
                throw new InitialisationException(CoreMessages.methodWithParamsNotFoundOnObject(this.methodName, this.argumentTypes, this.object.getClass()), (Initialisable)this);
            }
        } else {
            ArrayList<Method> matchingMethods = new ArrayList<Method>();
            int argSize = this.arguments != null ? this.arguments.size() : 0;
            for (Method methodCandidate : this.object.getClass().getMethods()) {
                if (!methodCandidate.getName().equals(this.methodName) || methodCandidate.getParameterTypes().length != argSize) continue;
                matchingMethods.add(methodCandidate);
            }
            if (matchingMethods.size() == 1) {
                this.method = (Method)matchingMethods.get(0);
                this.argumentTypes = this.method.getParameterTypes();
            } else {
                throw new InitialisationException(CoreMessages.methodWithNumParamsNotFoundOnObject(this.methodName, this.arguments.size(), this.object), (Initialisable)this);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Initialised %s to use method: '%s'", this, this.method));
        }
    }

    protected void lookupObjectInstance() throws InitialisationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("No object instance specified. Looking up single instance of type %s in mule registry", this.objectType));
        }
        try {
            this.object = ((MuleContextWithRegistry)this.muleContext).getRegistry().lookupObject(this.objectType);
        }
        catch (RegistrationException e) {
            throw new InitialisationException(CoreMessages.initialisationFailure(String.format("Muliple instances of '%s' were found in the registry so you need to configure a specific instance", this.objectType)), (Initialisable)this);
        }
        if (this.object == null) {
            throw new InitialisationException(CoreMessages.initialisationFailure(String.format("No instance of '%s' was found in the registry", this.objectType)), (Initialisable)this);
        }
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        CoreEvent resultEvent = event;
        Object[] args = this.evaluateArguments(event, this.arguments);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Invoking  '%s' of '%s' with arguments: '%s'", this.method.getName(), this.object, args));
        }
        try {
            Object result = this.method.invoke(this.object, args);
            if (!this.method.getReturnType().equals(Void.TYPE)) {
                resultEvent = this.createResultEvent(event, result);
            }
        }
        catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke(this.object.toString()), event, e, this);
        }
        return resultEvent;
    }

    protected Object[] evaluateArguments(CoreEvent event, List<?> argumentTemplates) throws MessagingException {
        int argSize = argumentTemplates != null ? argumentTemplates.size() : 0;
        Object[] args = new Object[argSize];
        try {
            for (int i = 0; i < args.length; ++i) {
                Object argumentTemplate = argumentTemplates.get(i);
                if (argumentTemplate == null) continue;
                args[i] = this.transformArgument(this.evaluateExpressionCandidate(argumentTemplate, event), this.argumentTypes[i]);
            }
            return args;
        }
        catch (TransformerException e) {
            throw new MessagingException(event, e, (Component)this);
        }
    }

    protected Object evaluateExpressionCandidate(Object expressionCandidate, CoreEvent event) throws TransformerException {
        if (expressionCandidate instanceof Collection) {
            Collection collectionTemplate = (Collection)expressionCandidate;
            ArrayList<Object> newCollection = new ArrayList<Object>();
            for (Object object : collectionTemplate) {
                newCollection.add(this.evaluateExpressionCandidate(object, event));
            }
            return newCollection;
        }
        if (expressionCandidate instanceof Map) {
            Map mapTemplate = (Map)expressionCandidate;
            HashMap<Object, Object> newMap = new HashMap<Object, Object>();
            for (Map.Entry entry : mapTemplate.entrySet()) {
                newMap.put(this.evaluateExpressionCandidate(entry.getKey(), event), this.evaluateExpressionCandidate(entry.getValue(), event));
            }
            return newMap;
        }
        if (expressionCandidate instanceof String[]) {
            String[] stringArrayTemplate = (String[])expressionCandidate;
            String[] newArray = new String[stringArrayTemplate.length];
            for (int j = 0; j < stringArrayTemplate.length; ++j) {
                newArray[j] = this.evaluateExpressionCandidate(stringArrayTemplate[j], event);
            }
            return newArray;
        }
        if (expressionCandidate instanceof String) {
            String expression = (String)expressionCandidate;
            String arg = expression.startsWith(this.patternInfo.getPrefix()) && expression.endsWith(this.patternInfo.getSuffix()) && expression.lastIndexOf(this.patternInfo.getPrefix()) == 0 ? this.expressionManager.evaluate(expression, event, this.getLocation()).getValue() : this.expressionManager.parse(expression, event, this.getLocation());
            if (arg instanceof Message) {
                arg = ((Message)((Object)arg)).getPayload().getValue();
            }
            return arg;
        }
        return expressionCandidate;
    }

    private Object transformArgument(Object arg, Class<?> type) throws TransformerException {
        if (!type.isAssignableFrom(arg.getClass())) {
            arg = ((MuleContextWithRegistry)this.muleContext).getRegistry().lookupTransformer(DataType.fromType(arg.getClass()), DataType.fromType(type)).transform(arg);
        }
        return arg;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setArgumentExpressionsString(String arguments) {
        this.arguments = InvokerMessageProcessorUtil.splitArgumentsExpression(arguments);
    }

    public void setArguments(List<?> arguments) {
        this.arguments = arguments;
    }

    protected CoreEvent createResultEvent(CoreEvent event, Object result) throws MuleException {
        CoreEvent.Builder eventBuilder = CoreEvent.builder(event);
        if (result instanceof Message) {
            eventBuilder.message((Message)result);
        } else if (result != null) {
            TransformerTemplate template = new TransformerTemplate(new TransformerTemplate.OverwitePayloadCallback(result));
            template.setReturnDataType(DataType.builder(DataType.OBJECT).charset(SystemUtils.getDefaultEncoding(this.muleContext)).build());
            eventBuilder.message(((ExtendedTransformationService)this.muleContext.getTransformationService()).applyTransformers(event.getMessage(), event, Collections.singletonList(template)));
        } else {
            eventBuilder.message(Message.of(null));
        }
        return eventBuilder.build();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setArgumentTypes(Class<?>[] argumentTypes) {
        this.argumentTypes = argumentTypes;
    }

    public String toString() {
        return String.format("InvokerMessageProcessor [name=%s, object=%s, methodName=%s, argExpressions=%s, argTypes=%s]", this.name, this.object, this.methodName, this.arguments, this.argumentTypes);
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setObjectType(Class<?> objectType) {
        this.objectType = objectType;
    }
}

