/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.persistence.MetadataTypeGsonTypeAdapter;
import org.mule.metadata.persistence.SerializationContext;
import org.mule.metadata.persistence.type.adapter.OptionalTypeAdapterFactory;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.stereotype.ImmutableStereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.extension.api.model.ImmutableExtensionModel;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.api.model.config.ImmutableConfigurationModel;
import org.mule.runtime.extension.api.model.connection.ImmutableConnectionProviderModel;
import org.mule.runtime.extension.api.model.deprecated.ImmutableDeprecationModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableExclusiveParametersModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceCallbackModel;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.internal.persistence.ConstructModelTypeAdapterFactory;
import org.mule.runtime.extension.internal.persistence.DefaultImplementationTypeAdapterFactory;
import org.mule.runtime.extension.internal.persistence.ElementDslModelTypeAdapter;
import org.mule.runtime.extension.internal.persistence.ErrorModelToIdentifierTypeAdapter;
import org.mule.runtime.extension.internal.persistence.ExtensionModelTypeAdapter;
import org.mule.runtime.extension.internal.persistence.FunctionModelTypeAdapterFactory;
import org.mule.runtime.extension.internal.persistence.ImportedTypesModelTypeAdapter;
import org.mule.runtime.extension.internal.persistence.ModelPropertyMapTypeAdapterFactory;
import org.mule.runtime.extension.internal.persistence.MuleVersionTypeAdapter;
import org.mule.runtime.extension.internal.persistence.NestableElementModelTypeAdapterFactory;
import org.mule.runtime.extension.internal.persistence.NotificationModelToIdentifierTypeAdapter;
import org.mule.runtime.extension.internal.persistence.OperationModelTypeAdapterFactory;
import org.mule.runtime.extension.internal.persistence.RestrictedTypesObjectTypeReferenceHandler;
import org.mule.runtime.extension.internal.persistence.SourceModelTypeAdapterFactory;
import org.mule.runtime.extension.internal.persistence.SubTypesModelTypeAdapter;
import org.mule.runtime.extension.internal.persistence.XmlDslModelTypeAdapter;

public class ExtensionModelJsonSerializer {
    private final boolean prettyPrint;
    private Set<ObjectType> registeredTypes = Collections.emptySet();
    private Set<ObjectType> importedTypes = Collections.emptySet();

    public ExtensionModelJsonSerializer() {
        this(false);
    }

    public ExtensionModelJsonSerializer(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    private Gson buildGson() {
        final SerializationContext serializationContext = new SerializationContext();
        final HashMap<String, ErrorModel> errorModelRepository = new HashMap<String, ErrorModel>();
        final HashMap<String, NotificationModel> notificationModelRepository = new HashMap<String, NotificationModel>();
        final Gson gsonDelegate = this.gsonBuilder(serializationContext, this.prettyPrint, errorModelRepository, notificationModelRepository).create();
        return this.gsonBuilder(serializationContext, this.prettyPrint, errorModelRepository, notificationModelRepository).registerTypeAdapterFactory(new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                if (ExtensionModel.class.isAssignableFrom(type.getRawType())) {
                    return new ExtensionModelTypeAdapter(gsonDelegate, serializationContext, errorModelRepository, notificationModelRepository);
                }
                return null;
            }
        }).create();
    }

    private GsonBuilder gsonBuilder(SerializationContext serializationContext, boolean prettyPrint, Map<String, ErrorModel> errorModelRepository, Map<String, NotificationModel> notificationModelRepository) {
        Set<String> registeredTypeIds = this.registeredTypes.stream().map(ExtensionMetadataTypeUtils::getId).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        this.importedTypes.forEach(type -> {
            ExtensionMetadataTypeUtils.getId(type).ifPresent(registeredTypeIds::add);
            serializationContext.registerObjectType((ObjectType)type);
        });
        RestrictedTypesObjectTypeReferenceHandler referenceHandler = new RestrictedTypesObjectTypeReferenceHandler(serializationContext, registeredTypeIds);
        DefaultImplementationTypeAdapterFactory<ConfigurationModel, ImmutableConfigurationModel> configurationModelTypeAdapterFactory = new DefaultImplementationTypeAdapterFactory<ConfigurationModel, ImmutableConfigurationModel>(ConfigurationModel.class, ImmutableConfigurationModel.class);
        DefaultImplementationTypeAdapterFactory<ConnectionProviderModel, ImmutableConnectionProviderModel> connectionProviderModelTypeAdapterFactory = new DefaultImplementationTypeAdapterFactory<ConnectionProviderModel, ImmutableConnectionProviderModel>(ConnectionProviderModel.class, ImmutableConnectionProviderModel.class);
        DefaultImplementationTypeAdapterFactory<SourceCallbackModel, ImmutableSourceCallbackModel> sourceCallbackModelTypeAdapterFactory = new DefaultImplementationTypeAdapterFactory<SourceCallbackModel, ImmutableSourceCallbackModel>(SourceCallbackModel.class, ImmutableSourceCallbackModel.class);
        DefaultImplementationTypeAdapterFactory<ParameterModel, ImmutableParameterModel> parameterModelTypeAdapterFactory = new DefaultImplementationTypeAdapterFactory<ParameterModel, ImmutableParameterModel>(ParameterModel.class, ImmutableParameterModel.class);
        DefaultImplementationTypeAdapterFactory<ParameterGroupModel, ImmutableParameterGroupModel> parameterGroupModelTypeAdapterFactory = new DefaultImplementationTypeAdapterFactory<ParameterGroupModel, ImmutableParameterGroupModel>(ParameterGroupModel.class, ImmutableParameterGroupModel.class);
        DefaultImplementationTypeAdapterFactory<ExclusiveParametersModel, ImmutableExclusiveParametersModel> exclusiveParametersTypeAdapterFactory = new DefaultImplementationTypeAdapterFactory<ExclusiveParametersModel, ImmutableExclusiveParametersModel>(ExclusiveParametersModel.class, ImmutableExclusiveParametersModel.class);
        DefaultImplementationTypeAdapterFactory<OutputModel, ImmutableOutputModel> outputModelTypeAdapterFactory = new DefaultImplementationTypeAdapterFactory<OutputModel, ImmutableOutputModel>(OutputModel.class, ImmutableOutputModel.class);
        DefaultImplementationTypeAdapterFactory<StereotypeModel, ImmutableStereotypeModel> stereotypeModelTypeAdapter = new DefaultImplementationTypeAdapterFactory<StereotypeModel, ImmutableStereotypeModel>(StereotypeModel.class, ImmutableStereotypeModel.class);
        DefaultImplementationTypeAdapterFactory<OAuthGrantType, AuthorizationCodeGrantType> oauthGrantTypeAdapter = new DefaultImplementationTypeAdapterFactory<OAuthGrantType, AuthorizationCodeGrantType>(OAuthGrantType.class, AuthorizationCodeGrantType.class);
        DefaultImplementationTypeAdapterFactory<DeprecationModel, ImmutableDeprecationModel> deprecationModelTypeAdapter = new DefaultImplementationTypeAdapterFactory<DeprecationModel, ImmutableDeprecationModel>(DeprecationModel.class, ImmutableDeprecationModel.class);
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(MetadataType.class, (Object)new MetadataTypeGsonTypeAdapter(referenceHandler)).registerTypeAdapter(MuleVersion.class, (Object)new MuleVersionTypeAdapter()).registerTypeAdapter(ImportedTypeModel.class, (Object)new ImportedTypesModelTypeAdapter()).registerTypeAdapter(SubTypesModel.class, (Object)new SubTypesModelTypeAdapter(referenceHandler)).registerTypeAdapter(XmlDslModel.class, (Object)new XmlDslModelTypeAdapter()).registerTypeAdapter(ParameterDslConfiguration.class, (Object)new ElementDslModelTypeAdapter()).registerTypeAdapter(ErrorModel.class, (Object)new ErrorModelToIdentifierTypeAdapter(errorModelRepository)).registerTypeAdapter(NotificationModel.class, (Object)new NotificationModelToIdentifierTypeAdapter(notificationModelRepository)).registerTypeAdapterFactory((TypeAdapterFactory)new OptionalTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new ModelPropertyMapTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new SourceModelTypeAdapterFactory()).registerTypeAdapterFactory(sourceCallbackModelTypeAdapterFactory).registerTypeAdapterFactory(parameterModelTypeAdapterFactory).registerTypeAdapterFactory(parameterGroupModelTypeAdapterFactory).registerTypeAdapterFactory(exclusiveParametersTypeAdapterFactory).registerTypeAdapterFactory(configurationModelTypeAdapterFactory).registerTypeAdapterFactory(connectionProviderModelTypeAdapterFactory).registerTypeAdapterFactory((TypeAdapterFactory)new OperationModelTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new ConstructModelTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new FunctionModelTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new NestableElementModelTypeAdapterFactory()).registerTypeAdapterFactory(outputModelTypeAdapterFactory).registerTypeAdapterFactory(stereotypeModelTypeAdapter).registerTypeAdapterFactory(oauthGrantTypeAdapter).registerTypeAdapterFactory(deprecationModelTypeAdapter);
        if (prettyPrint) {
            gsonBuilder.setPrettyPrinting();
        }
        return gsonBuilder;
    }

    public String serialize(ExtensionModel extensionModel) {
        this.registeredTypes = extensionModel.getTypes();
        this.importedTypes = extensionModel.getImportedTypes().stream().map(ImportedTypeModel::getImportedType).collect(Collectors.toSet());
        return this.buildGson().toJson((Object)extensionModel);
    }

    public String serializeList(List<ExtensionModel> extensionModelList) {
        return this.buildGson().toJson(extensionModelList);
    }

    public ExtensionModel deserialize(String extensionModel) {
        return (ExtensionModel)this.buildGson().fromJson(extensionModel, ImmutableExtensionModel.class);
    }

    public List<ExtensionModel> deserializeList(String extensionModelList) {
        return (List)this.buildGson().fromJson(extensionModelList, new TypeToken<List<ImmutableExtensionModel>>(){}.getType());
    }
}

