/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.generator.attachment;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;
import org.apache.cxf.message.Exchange;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.extension.api.soap.SoapAttachment;
import org.mule.runtime.soap.api.exception.EncodingException;
import org.mule.service.soap.generator.attachment.AttachmentResponseEnricher;
import org.mule.service.soap.generator.attachment.Base64Decoder;
import org.mule.wsdl.parser.model.operation.OperationModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class SoapAttachmentResponseEnricher
extends AttachmentResponseEnricher {
    private static final Base64Decoder decoder = new Base64Decoder();

    public SoapAttachmentResponseEnricher(TypeLoader loader, Map<String, OperationModel> operations) {
        super(loader, operations);
    }

    @Override
    protected void processResponseAttachments(Document response, List<ObjectFieldType> attachments, Exchange exchange) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        attachments.forEach(attachment -> {
            String attachmentName = MetadataTypeUtils.getLocalPart(attachment);
            builder.put((Object)attachmentName, (Object)this.getAttachment(response, attachmentName));
        });
        exchange.put((Object)"mule.soap.attachments", (Object)builder.build());
    }

    private SoapAttachment getAttachment(Document response, String name) {
        Node attachmentNode = response.getDocumentElement().getElementsByTagName(name).item(0);
        byte[] decodedAttachment = this.decodeAttachment(name, attachmentNode.getTextContent());
        response.getDocumentElement().removeChild(attachmentNode);
        return new SoapAttachment(new ByteArrayInputStream(decodedAttachment), MediaType.ANY);
    }

    private byte[] decodeAttachment(String name, String attachmentContent) {
        try {
            return (byte[])decoder.transform(attachmentContent);
        }
        catch (TransformerException e) {
            throw new EncodingException(String.format("Cannot decode base64 attachment [%s]", name));
        }
    }
}

