/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.lifecycle;

import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.phases.LifecyclePhase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLifecycleInterceptor
implements LifecycleInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLifecycleInterceptor.class);
    private Map<Object, Object> trackingPhaseFailureObjects = new WeakHashMap<Object, Object>();
    private Map<Object, Object> processedObjects = new WeakHashMap<Object, Object>();
    private final String initialPhase;
    private final String finalPhase;
    private final Class initialPhaseLifecycleClass;

    public DefaultLifecycleInterceptor(String initialPhase, String finalPhase, Class initialPhaseLifecycleClass) {
        this.initialPhase = initialPhase;
        this.finalPhase = finalPhase;
        this.initialPhaseLifecycleClass = initialPhaseLifecycleClass;
    }

    @Override
    public boolean beforePhaseExecution(LifecyclePhase phase, Object object) {
        if (this.isFinalPhase(phase) && this.initialPhaseLifecycleClass.isAssignableFrom(object.getClass()) && this.trackingPhaseFailureObjects.containsKey(object)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Skipping %s lifecycle phase on object because %s phase failed before it could be applied on it. Object is: %s", this.finalPhase, this.initialPhase, object));
            }
            return false;
        }
        if (this.isFinalPhase(phase) && this.initialPhaseLifecycleClass.isAssignableFrom(object.getClass())) {
            return this.processedObjects.containsKey(object);
        }
        this.processedObjects.put(object, object);
        return true;
    }

    @Override
    public void afterPhaseExecution(LifecyclePhase phase, Object object, Optional<Exception> exceptionThrownOptional) {
        if (this.isTrackingPhase(phase) && exceptionThrownOptional.isPresent()) {
            this.trackingPhaseFailureObjects.put(object, object);
        }
    }

    @Override
    public void onPhaseCompleted(LifecyclePhase phase) {
        if (this.isTrackingPhase(phase)) {
            this.trackingPhaseFailureObjects.clear();
        }
    }

    private boolean isTrackingPhase(LifecyclePhase phase) {
        return this.initialPhase.equals(phase.getName());
    }

    private boolean isFinalPhase(LifecyclePhase phase) {
        return this.finalPhase.equals(phase.getName());
    }
}

