/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tls.internal.revocation;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.ManagerFactoryParameters;
import org.mule.runtime.core.privileged.security.RevocationCheck;

public class StandardRevocationCheck
implements RevocationCheck {
    private Boolean onlyEndEntities = false;
    private Boolean preferCrls = false;
    private Boolean noFallback = false;
    private Boolean softFail = false;

    public void setOnlyEndEntities(Boolean onlyEndEntities) {
        this.onlyEndEntities = onlyEndEntities;
    }

    public void setPreferCrls(Boolean preferCrls) {
        this.preferCrls = preferCrls;
    }

    public void setNoFallback(Boolean noFallback) {
        this.noFallback = noFallback;
    }

    public void setSoftFail(Boolean softFail) {
        this.softFail = softFail;
    }

    @Override
    public ManagerFactoryParameters configFor(KeyStore trustStore, Set<TrustAnchor> defaultTrustAnchors) {
        try {
            CertPathBuilder cpb = CertPathBuilder.getInstance("PKIX");
            PKIXRevocationChecker rc = (PKIXRevocationChecker)cpb.getRevocationChecker();
            HashSet<PKIXRevocationChecker.Option> options = new HashSet<PKIXRevocationChecker.Option>();
            if (this.onlyEndEntities.booleanValue()) {
                options.add(PKIXRevocationChecker.Option.ONLY_END_ENTITY);
            }
            if (this.preferCrls.booleanValue()) {
                options.add(PKIXRevocationChecker.Option.PREFER_CRLS);
            }
            if (this.noFallback.booleanValue()) {
                options.add(PKIXRevocationChecker.Option.NO_FALLBACK);
            }
            if (this.softFail.booleanValue()) {
                options.add(PKIXRevocationChecker.Option.SOFT_FAIL);
            }
            rc.setOptions(options);
            PKIXBuilderParameters pkixParams = trustStore != null ? new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector()) : new PKIXBuilderParameters(defaultTrustAnchors, (CertSelector)new X509CertSelector());
            pkixParams.addCertPathChecker(rc);
            return new CertPathTrustManagerParameters(pkixParams);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandardRevocationCheck that = (StandardRevocationCheck)o;
        if (this.onlyEndEntities != null ? !this.onlyEndEntities.equals(that.onlyEndEntities) : that.onlyEndEntities != null) {
            return false;
        }
        if (this.preferCrls != null ? !this.preferCrls.equals(that.preferCrls) : that.preferCrls != null) {
            return false;
        }
        if (this.noFallback != null ? !this.noFallback.equals(that.noFallback) : that.noFallback != null) {
            return false;
        }
        return this.softFail != null ? this.softFail.equals(that.softFail) : that.softFail == null;
    }

    public int hashCode() {
        int result = this.onlyEndEntities != null ? this.onlyEndEntities.hashCode() : 0;
        result = 31 * result + (this.preferCrls != null ? this.preferCrls.hashCode() : 0);
        result = 31 * result + (this.noFallback != null ? this.noFallback.hashCode() : 0);
        result = 31 * result + (this.softFail != null ? this.softFail.hashCode() : 0);
        return result;
    }
}

