/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.retry.policy;

import org.mule.runtime.core.api.retry.policy.AbstractPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicy;
import org.mule.runtime.core.internal.retry.policies.SimpleRetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleRetryPolicyTemplate
extends AbstractPolicyTemplate {
    protected final transient Logger logger = LoggerFactory.getLogger(SimpleRetryPolicyTemplate.class);
    public static final int DEFAULT_FREQUENCY = 2000;
    public static final int DEFAULT_RETRY_COUNT = 2;
    public static final int RETRY_COUNT_FOREVER = -1;
    protected volatile int count = 2;
    protected volatile long frequency = 2000L;

    public SimpleRetryPolicyTemplate() {
    }

    public SimpleRetryPolicyTemplate(long frequency, int retryCount) {
        this.frequency = frequency;
        this.count = retryCount;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public int getCount() {
        return this.count;
    }

    public void setFrequency(long frequency) {
        this.frequency = frequency;
    }

    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public RetryPolicy createRetryInstance() {
        return new SimpleRetryPolicy(this.frequency, this.count);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SimpleRetryPolicy");
        sb.append("{frequency=").append(this.frequency);
        sb.append(", retryCount=").append(this.count);
        sb.append('}');
        return sb.toString();
    }
}

