/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import org.mule.metadata.api.model.VoidType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;

public class ValidatorModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel model, final ProblemsReporter problemsReporter) {
        new IdempotentExtensionWalker(){

            @Override
            protected void onOperation(OperationModel operation) {
                boolean hasValidationError;
                if (!operation.getStereotype().isAssignableTo(MuleStereotypes.VALIDATOR)) {
                    return;
                }
                if (!(operation.getOutput().getType() instanceof VoidType)) {
                    problemsReporter.addError(new Problem(operation, String.format("Operation '%s' is marked as a validator but it's not void.", operation.getName())));
                }
                if (!(hasValidationError = operation.getErrorModels().stream().filter(e -> ValidatorModelValidator.this.isValidation(e)).findAny().isPresent())) {
                    problemsReporter.addError(new Problem(operation, String.format("Operation '%s' is a validator but it doesn't declare a validation error. Upon failure, all validators must throw a Mule validation error or a child of one", operation.getName())));
                }
            }
        }.walk(model);
    }

    private boolean isValidation(ErrorModel errorModel) {
        if (MuleErrors.VALIDATION.getType().equals(errorModel.getType()) && "MULE".equals(errorModel.getNamespace())) {
            return true;
        }
        return errorModel.getParent().map(this::isValidation).orElse(false);
    }
}

