/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.streaming;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CursorResetInterceptor
implements Interceptor<OperationModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CursorResetInterceptor.class);
    private static final String CURSOR_POSITIONS = "CURSOR_POSITIONS";

    @Override
    public void before(ExecutionContext<OperationModel> ctx) throws Exception {
        HashMap cursorPositions = new HashMap();
        ctx.getParameters().forEach((key, value) -> {
            if (value instanceof Cursor) {
                Cursor cursor = (Cursor)value;
                cursorPositions.put(cursor, cursor.getPosition());
            }
        });
        if (!cursorPositions.isEmpty()) {
            ((ExecutionContextAdapter)ctx).setVariable(CURSOR_POSITIONS, cursorPositions);
        }
    }

    @Override
    public Throwable onError(ExecutionContext<OperationModel> executionContext, Throwable exception) {
        ExceptionUtils.extractConnectionException(exception).ifPresent(cne -> {
            Map cursorPositions = (Map)((ExecutionContextAdapter)executionContext).removeVariable(CURSOR_POSITIONS);
            if (cursorPositions != null) {
                cursorPositions.forEach((cursor, position) -> {
                    block2: {
                        try {
                            cursor.seek((long)position);
                        }
                        catch (IOException e) {
                            if (!LOGGER.isWarnEnabled()) break block2;
                            LOGGER.warn("Could not reset cursor back to position " + position + ". Inconsistencies might occur if reconnection attempted", (Throwable)e);
                        }
                    }
                });
            }
        });
        return exception;
    }
}

