/**
* This module contains the require stuff for registering a new Data Format on the language
*/
%dw 2.0

@AnnotationTarget(targets = ["Variable"])
annotation DataFormatExtension()

type MimeType = String

type Settings = {}

type EmptySettings = {}

type EncodingSettings = {
    /**
    * Encoding to be used by this writer.
    */
    encoding?: String
}

type DataFormat<ReaderSettings <: Settings, WriterSettings <: Settings> = {
    /**
    * True if this is data format is represented in a binary representation instead of text, if not present is false
    */
    binaryFormat?: Boolean,
    /**
    * The default charset of this format if any
    */
    defaultCharset?: String,

    /**
    * Returns the list of file extensions with the . (".json", ".xml", etc...) that should be assigned to this Data Format
    */
    fileExtensions?: Array<String>,

    /**
    * The list of MimeTypes that are accepted
    */
    acceptedMimeTypes: Array<MimeType>,

    /**
    * This function will be in charge of reading the raw content and transform it into the DW canonical model
    */
    reader: (content: Binary, charset: String, settings: ReaderSettings) -> Any,

    /**
    * This function will be in charge of writing the DW canonical model into Binary content
    */
    writer: (value:Any, settings:WriterSettings) -> Binary
}
