/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;
import org.mule.metadata.api.TypeWriter;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.MetadataSerializingException;
import org.mule.metadata.persistence.MetadataTypeWriter;

public abstract class AbstractJsonMetadataTypeWriter
implements TypeWriter,
MetadataTypeWriter {
    private static final String INDENT_TAB = "  ";
    protected JsonWriter writer;
    protected Stack<MetadataType> typeStack = new Stack();
    protected boolean prettyPrint;

    @Override
    public String toString(MetadataType structure) {
        try {
            StringWriter out = new StringWriter();
            this.writer = new JsonWriter((Writer)out);
            if (this.prettyPrint) {
                this.writer.setIndent(INDENT_TAB);
            }
            this.write(structure, this.writer);
            return out.toString();
        }
        catch (IOException e) {
            throw new MetadataSerializingException("the given MetadataType", e);
        }
    }

    @Override
    public void write(MetadataType metadataType, JsonWriter writer) throws IOException {
        this.writer = writer;
        this.write(metadataType);
        this.typeStack = new Stack();
    }

    protected abstract void write(MetadataType var1) throws IOException;

    public AbstractJsonMetadataTypeWriter setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        return this;
    }
}

