/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.execution.ArgumentResolverDelegate;
import org.mule.runtime.module.extension.internal.runtime.execution.MethodArgumentResolverDelegate;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationArgumentResolverFactory;
import org.mule.runtime.module.extension.internal.runtime.operation.ReflectiveMethodOperationExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ReflectiveMethodComponentExecutor<M extends ComponentModel>
implements MuleContextAware,
Lifecycle,
OperationArgumentResolverFactory<M> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectiveMethodOperationExecutor.class);
    private static final ArgumentResolverDelegate NO_ARGS_DELEGATE = new NoArgumentsResolverDelegate();
    private final List<ParameterGroupModel> groups;
    private final Method method;
    private final Object componentInstance;
    private final ClassLoader extensionClassLoader;
    private ArgumentResolverDelegate argumentResolverDelegate;
    private MuleContext muleContext;

    public ReflectiveMethodComponentExecutor(List<ParameterGroupModel> groups, Method method, Object componentInstance) {
        this.groups = groups;
        this.method = method;
        this.componentInstance = componentInstance;
        this.extensionClassLoader = method.getDeclaringClass().getClassLoader();
    }

    public Object execute(ExecutionContext<M> executionContext) {
        return ClassUtils.withContextClassLoader(this.extensionClassLoader, () -> ReflectionUtils.invokeMethod((Method)this.method, (Object)this.componentInstance, (Object[])Arrays.stream(this.getParameterValues(executionContext, this.method.getParameterTypes())).map(Supplier::get).toArray(Object[]::new)));
    }

    private Supplier<Object>[] getParameterValues(ExecutionContext<M> executionContext, Class<?>[] parameterTypes) {
        return this.argumentResolverDelegate.resolve(executionContext, parameterTypes);
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.componentInstance, true, this.muleContext);
        this.argumentResolverDelegate = ArrayUtils.isEmpty((Object[])this.method.getParameterTypes()) ? NO_ARGS_DELEGATE : this.getMethodArgumentResolver(this.groups, this.method);
    }

    private ArgumentResolverDelegate getMethodArgumentResolver(List<ParameterGroupModel> groups, Method method) {
        try {
            MethodArgumentResolverDelegate resolver = new MethodArgumentResolverDelegate(groups, method);
            LifecycleUtils.initialiseIfNeeded(resolver, this.muleContext);
            return resolver;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not initialize argument resolver resolver"), (Throwable)e);
        }
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.componentInstance);
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.componentInstance);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.componentInstance, LOGGER);
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        if (this.componentInstance instanceof MuleContextAware) {
            ((MuleContextAware)this.componentInstance).setMuleContext(context);
        }
    }

    @Override
    public Function<ExecutionContext<M>, Map<String, Object>> createArgumentResolver(M operationModel) {
        return ec -> ClassUtils.withContextClassLoader(this.extensionClassLoader, () -> {
            Supplier<Object>[] resolved = this.getParameterValues((ExecutionContext<M>)ec, this.method.getParameterTypes());
            HashMap<String, Supplier<Object>> resolvedParams = new HashMap<String, Supplier<Object>>();
            for (int i = 0; i < this.method.getParameterCount(); ++i) {
                resolvedParams.put(this.method.getParameters()[i].getName(), resolved[i]);
            }
            return resolvedParams;
        });
    }

    private static class NoArgumentsResolverDelegate
    implements ArgumentResolverDelegate {
        private static final Supplier[] EMPTY = new Supplier[0];

        private NoArgumentsResolverDelegate() {
        }

        @Override
        public Supplier<Object>[] resolve(ExecutionContext executionContext, Class<?>[] parameterTypes) {
            return EMPTY;
        }
    }
}

