/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.EntityMetadataProvider;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.internal.metadata.EntityMetadataMediator;
import org.mule.runtime.module.extension.internal.runtime.ExecutionTypeMapper;
import org.mule.runtime.module.extension.internal.runtime.operation.ComponentMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.IllegalOperationException;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class OperationMessageProcessor
extends ComponentMessageProcessor<OperationModel>
implements EntityMetadataProvider {
    static final String INVALID_TARGET_MESSAGE = "Root component '%s' defines an invalid usage of operation '%s' which uses %s as %s";
    private final EntityMetadataMediator entityMetadataMediator;

    public OperationMessageProcessor(ExtensionModel extensionModel, OperationModel operationModel, ConfigurationProvider configurationProvider, String target, String targetValue, ResolverSet resolverSet, CursorProviderFactory cursorProviderFactory, RetryPolicyTemplate retryPolicyTemplate, ExtensionManager extensionManager, PolicyManager policyManager, ReflectionCache reflectionCache) {
        super(extensionModel, operationModel, configurationProvider, target, targetValue, resolverSet, cursorProviderFactory, retryPolicyTemplate, extensionManager, policyManager, reflectionCache);
        this.entityMetadataMediator = new EntityMetadataMediator(operationModel);
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getEntityKeys() throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> ClassUtils.withContextClassLoader(this.classLoader, () -> this.entityMetadataMediator.getEntityKeys((MetadataContext)context)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onKeys());
        }
    }

    @Override
    public MetadataResult<TypeMetadataDescriptor> getEntityMetadata(MetadataKey key) throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> ClassUtils.withContextClassLoader(this.classLoader, () -> this.entityMetadataMediator.getEntityMetadata((MetadataContext)context, key)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onKeys());
        }
    }

    @Override
    protected void validateOperationConfiguration(ConfigurationProvider configurationProvider) {
        ConfigurationModel configurationModel = configurationProvider.getConfigurationModel();
        if (!configurationModel.getOperationModel(((OperationModel)this.componentModel).getName()).isPresent() && !configurationProvider.getExtensionModel().getOperationModel(((OperationModel)this.componentModel).getName()).isPresent()) {
            throw new IllegalOperationException(String.format("Root component '%s' defines an usage of operation '%s' which points to configuration '%s'. The selected config does not support that operation.", this.getLocation().getRootContainerName(), ((OperationModel)this.componentModel).getName(), configurationProvider.getName()));
        }
    }

    @Override
    public ReactiveProcessor.ProcessingType getProcessingType() {
        ReactiveProcessor.ProcessingType processingType = ExecutionTypeMapper.asProcessingType(((OperationModel)this.componentModel).getExecutionType());
        if (processingType == ReactiveProcessor.ProcessingType.CPU_LITE && !((OperationModel)this.componentModel).isBlocking()) {
            return ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC;
        }
        return processingType;
    }
}

