/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.threads;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.mule.runtime.core.api.util.ClassUtils;

public class SchedulerThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final String nameFormat;
    private final AtomicLong counter;
    private AccessControlContext acc = AccessController.getContext();

    public SchedulerThreadFactory(ThreadGroup group) {
        this(group, "%s.%02d");
    }

    public SchedulerThreadFactory(ThreadGroup group, String nameFormat) {
        this.group = group;
        this.nameFormat = nameFormat;
        this.counter = new AtomicLong(1L);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        return ClassUtils.withContextClassLoader(this.getClass().getClassLoader(), () -> AccessController.doPrivileged(() -> new Thread(this.group, runnable, String.format(this.nameFormat, this.group.getName(), this.counter.getAndIncrement())), this.acc));
    }

    public ThreadGroup getGroup() {
        return this.group;
    }

    public AtomicLong getCounter() {
        return this.counter;
    }
}

