/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.config.internal.MuleArtifactContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.event.EventQuickCopy;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.processor.chain.SubflowMessageProcessorChainBuilder;
import org.mule.runtime.core.internal.util.rx.Operators;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.AnnotatedProcessor;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.routing.RoutePathNotFoundException;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FlowRefFactoryBean
extends AbstractComponentFactory<Processor>
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowRefFactoryBean.class);
    private String refName;
    private String target;
    private String targetValue = "#[payload]";
    private ApplicationContext applicationContext;
    private MuleContext muleContext;
    @Inject
    private ExtendedExpressionManager expressionManager;
    @Inject
    private ConfigurationComponentLocator locator;

    public void setName(String name) {
        this.refName = name;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = targetValue;
    }

    @Override
    public Processor doGetObject() throws Exception {
        if (this.refName.isEmpty()) {
            throw new IllegalArgumentException("flow-ref name is empty");
        }
        return new FlowRefMessageProcessor();
    }

    protected Processor getReferencedFlow(String name, FlowRefMessageProcessor flowRefMessageProcessor) throws MuleException {
        if (name == null) {
            throw new RoutePathNotFoundException(I18nMessageFactory.createStaticMessage("flow-ref name expression returned 'null'"), flowRefMessageProcessor);
        }
        Component referencedFlow = this.getReferencedProcessor(name);
        if (referencedFlow == null) {
            throw new RoutePathNotFoundException(I18nMessageFactory.createStaticMessage("No flow/sub-flow with name '%s' found", name), flowRefMessageProcessor);
        }
        if (!(referencedFlow instanceof Flow)) {
            if (referencedFlow instanceof SubflowMessageProcessorChainBuilder) {
                MessageProcessorChainBuilder chainBuilder = (MessageProcessorChainBuilder)((Object)referencedFlow);
                this.locator.find(flowRefMessageProcessor.getRootContainerLocation()).filter(c -> c instanceof Flow).map(c -> (Flow)c).ifPresent(f -> {
                    final ProcessingStrategy callerFlowPs = f.getProcessingStrategy();
                    chainBuilder.setProcessingStrategy(new ProcessingStrategy(){

                        @Override
                        public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor pipeline) {
                            return callerFlowPs.createSink(flowConstruct, pipeline);
                        }

                        @Override
                        public ReactiveProcessor onPipeline(ReactiveProcessor pipeline) {
                            return pipeline;
                        }

                        @Override
                        public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
                            return callerFlowPs.onProcessor(processor);
                        }
                    });
                });
                referencedFlow = chainBuilder.build();
            }
            LifecycleUtils.initialiseIfNeeded(referencedFlow, this.muleContext);
            HashMap<QName, Object> annotations = new HashMap<QName, Object>(referencedFlow.getAnnotations());
            annotations.put(ROOT_CONTAINER_NAME_KEY, this.getRootContainerLocation().toString());
            referencedFlow.setAnnotations(annotations);
            LifecycleUtils.startIfNeeded(referencedFlow);
        }
        return (Processor)((Object)referencedFlow);
    }

    private Component getReferencedProcessor(String name) {
        if (this.applicationContext instanceof MuleArtifactContext) {
            MuleArtifactContext muleArtifactContext = (MuleArtifactContext)this.applicationContext;
            try {
                if (muleArtifactContext.getBeanFactory().getBeanDefinition(name).isPrototype()) {
                    muleArtifactContext.getPrototypeBeanWithRootContainer(name, this.getRootContainerLocation().toString());
                }
            }
            catch (NoSuchBeanDefinitionException e) {
                return null;
            }
        }
        return (Component)this.applicationContext.getBean(name);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        try {
            this.muleContext.getInjector().inject(this);
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(e);
        }
    }

    private class FlowRefMessageProcessor
    extends AbstractComponent
    implements AnnotatedProcessor,
    Stoppable,
    Disposable {
        private LoadingCache<String, Processor> cache;
        private boolean isExpression;

        public FlowRefMessageProcessor() {
            this.cache = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<String, Processor>(){

                public Processor load(String key) throws Exception {
                    return FlowRefFactoryBean.this.getReferencedFlow(key, FlowRefMessageProcessor.this);
                }
            });
            this.isExpression = FlowRefFactoryBean.this.expressionManager.isExpression(FlowRefFactoryBean.this.refName);
        }

        @Override
        public CoreEvent process(CoreEvent event) throws MuleException {
            return MessageProcessors.processToApply(event, this);
        }

        @Override
        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            return Flux.from(publisher).flatMap(event -> {
                Processor resolvedReferencedProcessor;
                try {
                    resolvedReferencedProcessor = this.resolveReferencedProcessor((CoreEvent)event);
                }
                catch (MuleException e) {
                    return Flux.error((Throwable)e);
                }
                ReactiveProcessor referencedProcessor = p -> Mono.from((Publisher)p).transform((Function)resolvedReferencedProcessor).onErrorMap(MessagingException.class, me -> new MessagingException(EventQuickCopy.quickCopy((EventContext)((BaseEventContext)me.getEvent().getContext()).getParentContext().get(), me.getEvent()), (MessagingException)me));
                return Mono.from(resolvedReferencedProcessor instanceof Flow ? MessageProcessors.processWithChildContext(event, referencedProcessor, Optional.ofNullable(FlowRefFactoryBean.this.getLocation()), ((Flow)resolvedReferencedProcessor).getExceptionListener()) : MessageProcessors.processWithChildContext(event, referencedProcessor, Optional.ofNullable(FlowRefFactoryBean.this.getLocation()))).map(Operators.outputToTarget(event, FlowRefFactoryBean.this.target, FlowRefFactoryBean.this.targetValue, FlowRefFactoryBean.this.expressionManager));
            });
        }

        protected Processor resolveReferencedProcessor(CoreEvent event) throws MuleException {
            String flowName = this.isExpression ? FlowRefFactoryBean.this.expressionManager.parse(FlowRefFactoryBean.this.refName, event, this.getLocation()) : FlowRefFactoryBean.this.refName;
            try {
                return (Processor)this.cache.getUnchecked((Object)flowName);
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof MuleRuntimeException) {
                    throw (MuleRuntimeException)e.getCause();
                }
                if (e.getCause() instanceof MuleException) {
                    throw (MuleException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public ComponentLocation getLocation() {
            return FlowRefFactoryBean.this.getLocation();
        }

        @Override
        public void stop() throws MuleException {
            for (Processor p : this.cache.asMap().values()) {
                if (p instanceof Flow) continue;
                LifecycleUtils.stopIfNeeded(p);
            }
        }

        @Override
        public void dispose() {
            for (Processor p : this.cache.asMap().values()) {
                if (p instanceof Flow) continue;
                LifecycleUtils.disposeIfNeeded(p, LOGGER);
            }
            this.cache.invalidateAll();
            this.cache.cleanUp();
        }
    }
}

