/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.lang.reflect.Type;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.util.InfrastructureParameterBuilder;

public final class RedeliveryPolicyDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        final Reference<Boolean> hasObjectStoreParams = new Reference<Boolean>(false);
        ExtensionDeclaration extension = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
        new IdempotentDeclarationWalker(){

            @Override
            protected void onSource(SourceDeclaration declaration) {
                InfrastructureParameterBuilder.addRedeliveryPolicy(declaration);
                hasObjectStoreParams.set(true);
            }
        }.walk(extension);
        if (hasObjectStoreParams.get().booleanValue() && !this.isObjectStoreAlreadyImported(extension)) {
            ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
            extension.getImportedTypes().add(new ImportedTypeModel((ObjectType)typeLoader.load((Type)((Object)ObjectStore.class))));
        }
    }

    private boolean isObjectStoreAlreadyImported(ExtensionDeclaration extension) {
        return extension.getImportedTypes().stream().anyMatch(model -> this.isObjectStore(model.getImportedType()));
    }

    private boolean isObjectStore(MetadataType type) {
        return MetadataTypeUtils.getTypeId(type).filter(typeId -> ObjectStore.class.getName().equals(typeId)).isPresent();
    }
}

