/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.ClientCredentials;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsState;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class OAuthConnectionProviderModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel model, ProblemsReporter problemsReporter) {
        new IdempotentExtensionWalker(){

            @Override
            protected void onConnectionProvider(ConnectionProviderModel model) {
                Class implementingType = model.getModelProperty(ImplementingTypeModelProperty.class).map(ImplementingTypeModelProperty::getType).orElse(null);
                if (implementingType == null) {
                    return;
                }
                AuthorizationCode authCode = implementingType.getAnnotation(AuthorizationCode.class);
                ClientCredentials clientCredentials = implementingType.getAnnotation(ClientCredentials.class);
                if (authCode != null && clientCredentials != null) {
                    throw new IllegalConnectionProviderModelDefinitionException(String.format("Connection Provider of class '%s' is attempting to support both authorization code and client credentials grant types. Each connection provider can only support one grant type at a time.", implementingType));
                }
                if (authCode != null) {
                    OAuthConnectionProviderModelValidator.this.validateStateField(implementingType, AuthorizationCodeState.class, "authorization code");
                }
                if (clientCredentials != null) {
                    OAuthConnectionProviderModelValidator.this.validateStateField(implementingType, ClientCredentialsState.class, "client credentials");
                }
            }
        }.walk(model);
    }

    private void validateStateField(Class<?> implementingType, Class<?> stateFieldType, String grantType) {
        List stateFields = IntrospectionUtils.getFields(implementingType).stream().filter(f -> f.getType().equals(stateFieldType)).collect(Collectors.toList());
        if (stateFields.size() != 1) {
            throw new IllegalConnectionProviderModelDefinitionException(String.format("Connection Provider of class '%s' uses OAuth2 %s grant type and thus should contain one (and only one) field of type %s. %d were found", implementingType, grantType, AuthorizationCodeState.class.getName(), stateFields.size()));
        }
    }
}

