/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.core.internal.connection.ReconnectableConnectionProviderWrapper;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.module.extension.internal.util.FieldSetter;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;

public abstract class OAuthConnectionProviderWrapper<C>
extends ReconnectableConnectionProviderWrapper<C> {
    protected final Map<Field, String> callbackValues;

    public OAuthConnectionProviderWrapper(ConnectionProvider<C> delegate, ReconnectionConfig reconnectionConfig, Map<Field, String> callbackValues) {
        super(delegate, reconnectionConfig);
        this.callbackValues = Collections.unmodifiableMap(callbackValues);
    }

    public abstract OAuthGrantType getGrantType();

    public abstract void refreshToken(String var1);

    public abstract void invalidate(String var1);

    protected <T> FieldSetter<ConnectionProvider<C>, T> getOAuthStateSetter(ConnectionProvider<C> delegate, Class<T> stateType, String grantTypeName) {
        List stateFields = IntrospectionUtils.getFields(delegate.getClass()).stream().filter(f -> f.getType().equals(stateType)).collect(Collectors.toList());
        if (stateFields.size() != 1) {
            throw new IllegalConnectionProviderModelDefinitionException(String.format("Connection Provider of class '%s' uses OAuth2 %s grant type and thus should contain one (and only one) field of type %s. %d were found", delegate.getClass().getName(), grantTypeName, stateType, stateFields.size()));
        }
        return new FieldSetter((Field)stateFields.get(0));
    }

    protected void updateOAuthParameters(ConnectionProvider<C> delegate, ResourceOwnerOAuthContext context) {
        Map<String, Object> responseParameters = context.getTokenResponseParameters();
        this.callbackValues.keySet().forEach(field -> {
            String key = field.getName();
            if (responseParameters.containsKey(key)) {
                new FieldSetter((Field)field).set(delegate, responseParameters.get(key));
            }
        });
    }
}

