/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.reader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.mule.weave.v2.module.reader.CharsetEncoder;
import org.mule.weave.v2.module.reader.CharsetEncoder$;
import org.mule.weave.v2.module.reader.StreamDecoder$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Us!B\u0001\u0003\u0011\u0003y\u0011!D*ue\u0016\fW\u000eR3d_\u0012,'O\u0003\u0002\u0004\t\u00051!/Z1eKJT!!\u0002\u0004\u0002\r5|G-\u001e7f\u0015\t9\u0001\"\u0001\u0002we)\u0011\u0011BC\u0001\u0006o\u0016\fg/\u001a\u0006\u0003\u00171\tA!\\;mK*\tQ\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u0011#5\t!AB\u0003\u0013\u0005!\u00051CA\u0007TiJ,\u0017-\u001c#fG>$WM]\n\u0003#Q\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0007\"B\u000e\u0012\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u0010\u0011\u001dq\u0012C1A\u0005\n}\t\u0001\u0004R#G\u0003VcEk\u0018\"Z)\u0016{&)\u0016$G\u000bJ{6+\u0013.F+\u0005\u0001\u0003CA\u000b\"\u0013\t\u0011cCA\u0002J]RDa\u0001J\t!\u0002\u0013\u0001\u0013!\u0007#F\r\u0006+F\nV0C3R+uLQ+G\r\u0016\u0013vlU%[\u000b\u0002BQAJ\t\u0005\u0002\u001d\nACZ8s\u0013:\u0004X\u000f^*ue\u0016\fWNU3bI\u0016\u0014H#\u0002\u0015\u0002R\u0005M\u0003C\u0001\t*\r\u0011\u0011\"\u0001\u0001\u0016\u0014\u0005%\"\u0002\u0002\u0003\u0017*\u0005\u000b\u0007I\u0011A\u0017\u0002\u0005%tW#\u0001\u0018\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014AA5p\u0015\u0005\u0019\u0014\u0001\u00026bm\u0006L!!\u000e\u0019\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\to%\u0012\t\u0011)A\u0005]\u0005\u0019\u0011N\u001c\u0011\t\u0011eJ#Q1A\u0005\u0002i\n!aY:\u0016\u0003m\u0002\"\u0001P!\u000e\u0003uR!AP \u0002\u000f\rD\u0017M]:fi*\u0011\u0001IM\u0001\u0004]&|\u0017B\u0001\">\u0005\u001d\u0019\u0005.\u0019:tKRD\u0001\u0002R\u0015\u0003\u0002\u0003\u0006IaO\u0001\u0004GN\u0004\u0003\"B\u000e*\t\u00031Ec\u0001\u0015H\u0011\")A&\u0012a\u0001]!)\u0011(\u0012a\u0001w!9!*\u000bb\u0001\n\u0013Y\u0015a\u00023fG>$WM]\u000b\u0002\u0019B\u0011A(T\u0005\u0003\u001dv\u0012ab\u00115beN,G\u000fR3d_\u0012,'\u000f\u0003\u0004QS\u0001\u0006I\u0001T\u0001\tI\u0016\u001cw\u000eZ3sA!A!+\u000bEC\u0002\u0013%1+\u0001\u0002cEV\tA\u000b\u0005\u0002V-6\tq(\u0003\u0002X\u007f\tQ!)\u001f;f\u0005V4g-\u001a:\t\u0011eK\u0003R1A\u0005\ni\u000bq!\u001a8d_\u0012,'/F\u0001\\!\t\u0001B,\u0003\u0002^\u0005\tq1\t[1sg\u0016$XI\\2pI\u0016\u0014\bbB0*\u0001\u0004%I\u0001Y\u0001\u0011Q\u00064X\rT3gi>4XM]\"iCJ,\u0012!\u0019\t\u0003+\tL!a\u0019\f\u0003\u000f\t{w\u000e\\3b]\"9Q-\u000ba\u0001\n\u00131\u0017\u0001\u00065bm\u0016dUM\u001a;pm\u0016\u00148\t[1s?\u0012*\u0017\u000f\u0006\u0002hUB\u0011Q\u0003[\u0005\u0003SZ\u0011A!\u00168ji\"91\u000eZA\u0001\u0002\u0004\t\u0017a\u0001=%c!1Q.\u000bQ!\n\u0005\f\u0011\u0003[1wK2+g\r^8wKJ\u001c\u0005.\u0019:!\u0011\u001dy\u0017\u00061A\u0005\nA\fA\u0002\\3gi>4XM]\"iCJ,\u0012!\u001d\t\u0003+IL!a\u001d\f\u0003\t\rC\u0017M\u001d\u0005\bk&\u0002\r\u0011\"\u0003w\u0003AaWM\u001a;pm\u0016\u00148\t[1s?\u0012*\u0017\u000f\u0006\u0002ho\"91\u000e^A\u0001\u0002\u0004\t\bBB=*A\u0003&\u0011/A\u0007mK\u001a$xN^3s\u0007\"\f'\u000f\t\u0005\u0006w&\"\t\u0001`\u0001\u0016e\u0016l\u0017-\u001b8j]\u001e\u0014\u0015\u0010^3t\u0013:\u001c\u0015m\u00195f)\u0005\u0001\u0003\"\u0002@*\t\u0003y\u0018a\u00032zi\u0016\u001cH*\u001a8hi\"$2\u0001IA\u0001\u0011\u0019\t\u0019! a\u0001c\u0006\t1\rC\u0004\u0002\b%\"\t!!\u0003\u0002\u000b\rdW-\u0019:\u0015\u0003\u001dDa!!\u0004*\t\u0003a\u0018A\u00023fG>$W\r\u000b\u0004\u0002\f\u0005E\u0011Q\u0004\t\u0006+\u0005M\u0011qC\u0005\u0004\u0003+1\"A\u0002;ie><8\u000fE\u00020\u00033I1!a\u00071\u0005-Iu*\u0012=dKB$\u0018n\u001c8$\u0005\u0005]\u0001bBA\u0011S\u0011\u0005\u00111E\u0001\u0005e\u0016\fG\rF\u0004!\u0003K\ty#a\r\t\u0011\u0005\u001d\u0012q\u0004a\u0001\u0003S\tAa\u00192vMB!Q#a\u000br\u0013\r\tiC\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0003c\ty\u00021\u0001!\u0003\u0019ygMZ:fi\"9\u0011QGA\u0010\u0001\u0004\u0001\u0013A\u00027f]\u001e$\b\u000e\u000b\u0004\u0002 \u0005E\u0011Q\u0004\u0005\u0007\u0003wIC\u0011B\u0010\u0002\u0013I,\u0017\r\u001a\"zi\u0016\u001c\bFBA\u001d\u0003#\ti\u0002C\u0004\u0002B%\"I!a\u0011\u0002\u0011%l\u0007\u000f\u001c*fC\u0012$r\u0001IA#\u0003\u000f\nY\u0005\u0003\u0005\u0002(\u0005}\u0002\u0019AA\u0015\u0011\u001d\tI%a\u0010A\u0002\u0001\n1a\u001c4g\u0011\u001d\ti%a\u0010A\u0002\u0001\n1!\u001a8eQ\u0019\ty$!\u0005\u0002\u001e!)A&\na\u0001]!)\u0011(\na\u0001w\u0001")
public class StreamDecoder {
    private ByteBuffer bb;
    private CharsetEncoder encoder;
    private final InputStream in;
    private final Charset cs;
    private final CharsetDecoder decoder;
    private boolean haveLeftoverChar;
    private char leftoverChar;
    private volatile byte bitmap$0;

    public static StreamDecoder forInputStreamReader(InputStream inputStream, Charset charset) {
        return StreamDecoder$.MODULE$.forInputStreamReader(inputStream, charset);
    }

    public InputStream in() {
        return this.in;
    }

    public Charset cs() {
        return this.cs;
    }

    private CharsetDecoder decoder() {
        return this.decoder;
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuffer bb$lzycompute() {
        StreamDecoder streamDecoder = this;
        synchronized (streamDecoder) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                ByteBuffer byteBuffer = ByteBuffer.allocate(StreamDecoder$.MODULE$.org$mule$weave$v2$module$reader$StreamDecoder$$DEFAULT_BYTE_BUFFER_SIZE());
                byteBuffer.flip();
                this.bb = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.bb;
    }

    private ByteBuffer bb() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.bb$lzycompute() : this.bb;
    }

    private CharsetEncoder encoder$lzycompute() {
        StreamDecoder streamDecoder = this;
        synchronized (streamDecoder) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.encoder = CharsetEncoder$.MODULE$.apply(this.cs());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.encoder;
    }

    private CharsetEncoder encoder() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.encoder$lzycompute() : this.encoder;
    }

    private boolean haveLeftoverChar() {
        return this.haveLeftoverChar;
    }

    private void haveLeftoverChar_$eq(boolean x$1) {
        this.haveLeftoverChar = x$1;
    }

    private char leftoverChar() {
        return this.leftoverChar;
    }

    private void leftoverChar_$eq(char x$1) {
        this.leftoverChar = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public int remainingBytesInCache() {
        void var1_1;
        block0: {
            int remaining = this.bb().remaining();
            if (!this.haveLeftoverChar()) break block0;
            remaining += this.bytesLength(this.leftoverChar());
        }
        return (int)var1_1;
    }

    public int bytesLength(char c) {
        return this.encoder().bytesLength(c);
    }

    public void clear() {
        this.bb().clear();
        this.bb().flip();
        this.haveLeftoverChar_$eq(false);
    }

    public int decode() throws IOException {
        int n;
        if (this.haveLeftoverChar()) {
            this.haveLeftoverChar_$eq(false);
            n = this.leftoverChar();
        } else {
            int n2;
            char[] cb = new char[2];
            int n3 = n2 = this.read(cb, 0, cb.length);
            switch (n3) {
                case 2: {
                    this.leftoverChar_$eq(cb[1]);
                    this.haveLeftoverChar_$eq(true);
                    n = cb[0];
                    break;
                }
                case 1: {
                    n = cb[0];
                    break;
                }
                default: {
                    n = -1;
                    break;
                }
            }
        }
        return n;
    }

    public int read(char[] cbuf, int offset, int length) throws IOException {
        if (offset < 0 || offset > cbuf.length || length < 0 || offset + length > cbuf.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        return length == 0 ? 0 : this.implRead(cbuf, offset, offset + length);
    }

    private int readBytes() throws IOException {
        block6: {
            int n;
            block5: {
                this.bb().compact();
                try {
                    int lim = this.bb().limit();
                    int pos = this.bb().position();
                    int rem = pos <= lim ? lim - pos : 0;
                    int n2 = this.in().read(this.bb().array(), this.bb().arrayOffset() + pos, rem);
                    if (n2 < 0) {
                        n = n2;
                        break block5;
                    }
                    if (n2 == 0) {
                        throw new IOException("Underlying input stream returned zero bytes");
                    }
                    this.bb().position(pos + n2);
                    break block6;
                }
                finally {
                    this.bb().flip();
                }
            }
            return n;
        }
        return this.bb().remaining();
    }

    private int implRead(char[] cbuf, int off, int end) throws IOException {
        CharBuffer cb = CharBuffer.wrap(cbuf, off, end - off);
        if (cb.position() != 0) {
            cb = cb.slice();
        }
        boolean eof = false;
        boolean needMoreBytes = true;
        Object object = this.bb().remaining() == 0 ? BoxesRunTime.boxToInteger((int)this.readBytes()) : BoxedUnit.UNIT;
        while (needMoreBytes) {
            Object object2;
            CoderResult cr = this.decoder().decode(this.bb(), cb, eof);
            if (cr.isUnderflow()) {
                if (eof) {
                    needMoreBytes = false;
                    object2 = BoxedUnit.UNIT;
                    continue;
                }
                if (!cb.hasRemaining()) {
                    needMoreBytes = false;
                    object2 = BoxedUnit.UNIT;
                    continue;
                }
                if (cb.position() > 0) {
                    needMoreBytes = false;
                    object2 = BoxedUnit.UNIT;
                    continue;
                }
                int n = this.readBytes();
                if (n < 0) {
                    eof = true;
                    if (cb.position() == 0 && !this.bb().hasRemaining()) {
                        needMoreBytes = false;
                        object2 = BoxedUnit.UNIT;
                        continue;
                    }
                    object2 = this.decoder().reset();
                    continue;
                }
                object2 = BoxedUnit.UNIT;
                continue;
            }
            if (cr.isOverflow()) {
                needMoreBytes = false;
            } else {
                cr.throwException();
            }
            object2 = BoxedUnit.UNIT;
        }
        Object object3 = eof ? this.decoder().reset() : BoxedUnit.UNIT;
        if (cb.position() == 0 && eof) {
            return -1;
        }
        return cb.position();
    }

    public StreamDecoder(InputStream in, Charset cs) {
        this.in = in;
        this.cs = cs;
        this.decoder = cs.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.haveLeftoverChar = false;
        this.leftoverChar = '\u0000';
    }
}

