/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context.thread.notification;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.core.internal.context.thread.notification.ThreadNotificationLogger;

public class ThreadLoggingExecutorServiceDecorator
implements ExecutorService {
    private ExecutorService delegate;
    private Optional<ThreadNotificationLogger> threadNotificationLogger;
    private String eventId;

    public ThreadLoggingExecutorServiceDecorator(Optional<ThreadNotificationLogger> logger, ExecutorService delegate, String eventId) {
        this.delegate = delegate;
        this.threadNotificationLogger = logger;
        this.eventId = eventId;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.threadNotificationLogger.ifPresent(logger -> logger.setStartingThread(this.eventId));
        return this.delegate.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.threadNotificationLogger.ifPresent(logger -> logger.setStartingThread(this.eventId));
        return this.delegate.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.threadNotificationLogger.ifPresent(logger -> logger.setStartingThread(this.eventId));
        return this.delegate.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.threadNotificationLogger.ifPresent(logger -> logger.setStartingThread(this.eventId));
        return this.delegate.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        this.threadNotificationLogger.ifPresent(logger -> logger.setStartingThread(this.eventId));
        return this.delegate.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        this.threadNotificationLogger.ifPresent(logger -> logger.setStartingThread(this.eventId));
        return this.delegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.threadNotificationLogger.ifPresent(logger -> logger.setStartingThread(this.eventId));
        return this.delegate.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.threadNotificationLogger.ifPresent(logger -> logger.setStartingThread(this.eventId));
        this.delegate.execute(command);
    }
}

