/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.policy.PolicyNotificationHelper;
import org.mule.runtime.core.privileged.event.BaseEventContext;

public class OnExecuteNextErrorConsumer
implements Consumer<Throwable> {
    private final Function<CoreEvent, CoreEvent> prepareEvent;
    private final PolicyNotificationHelper notificationHelper;
    private final ComponentLocation location;

    public OnExecuteNextErrorConsumer(Function<CoreEvent, CoreEvent> prepareEvent, PolicyNotificationHelper notificationHelper, ComponentLocation location) {
        this.prepareEvent = prepareEvent;
        this.notificationHelper = notificationHelper;
        this.location = location;
    }

    @Override
    public void accept(Throwable error) {
        MessagingException me = (MessagingException)error;
        if (this.isEventContextHandledByThisNext(me.getEvent())) {
            CoreEvent newEvent = this.prepareEvent.apply(me.getEvent());
            me.setProcessedEvent(newEvent);
            this.notificationHelper.fireNotification(newEvent, me, 2103);
            this.pushAfterNextFlowStackElement().accept(newEvent);
            ((BaseEventContext)newEvent.getContext()).error(error);
        }
    }

    private Consumer<CoreEvent> pushAfterNextFlowStackElement() {
        return event -> ((DefaultFlowCallStack)event.getFlowCallStack()).push(new FlowStackElement(this.toPolicyLocation(this.location), null));
    }

    private String toPolicyLocation(ComponentLocation componentLocation) {
        return componentLocation.getParts().get(0).getPartPath() + "/" + componentLocation.getParts().get(1).getPartPath() + "[after next]";
    }

    private boolean isEventContextHandledByThisNext(CoreEvent event) {
        Set eventCtxIds = (Set)((InternalEvent)event).getInternalParameter("policy.next.eventCtxIds");
        return eventCtxIds != null && eventCtxIds.contains(event.getContext().getId());
    }
}

