/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence;

import java.util.List;
import java.util.Objects;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataAttributes;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.extension.internal.persistence.Descriptable;

public class ComponentMetadataResult<T extends ComponentModel>
implements Descriptable<MetadataResult<ComponentMetadataDescriptor<T>>> {
    static final String TYPE = "type";
    static final String COMPONENT = "component";
    static final String OPERATION = "OPERATION";
    static final String SOURCE = "SOURCE";
    private final T model;
    private final String type;
    private final MetadataAttributes metadataAttributes;
    private final List<MetadataFailure> failures;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ComponentMetadataResult(MetadataResult<ComponentMetadataDescriptor<T>> result) {
        ComponentMetadataDescriptor<T> descriptor = result.get();
        this.model = descriptor != null ? descriptor.getModel() : null;
        MetadataAttributes metadataAttributes = this.metadataAttributes = descriptor != null ? descriptor.getMetadataAttributes() : null;
        if (this.model != null) {
            if (this.model instanceof OperationModel) {
                this.type = OPERATION;
            } else {
                if (!(this.model instanceof SourceModel)) throw new IllegalArgumentException("Unknown model type");
                this.type = SOURCE;
            }
        } else {
            this.type = null;
        }
        this.failures = result.getFailures();
    }

    public boolean isOperation() {
        return Objects.equals(this.type, OPERATION);
    }

    public boolean isSource() {
        return Objects.equals(this.type, SOURCE);
    }

    public T getModel() {
        return this.model;
    }

    public MetadataAttributes getMetadataAttributes() {
        return this.metadataAttributes;
    }

    public List<MetadataFailure> getFailures() {
        return this.failures;
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<T>> toDescriptor() {
        ComponentMetadataDescriptor<T> descriptor = ComponentMetadataDescriptor.builder(this.model).withAttributes(this.metadataAttributes).build();
        return this.failures.isEmpty() ? MetadataResult.success(descriptor) : MetadataResult.failure(descriptor, this.failures);
    }
}

