/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.ExpressionFunctions;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.module.extension.api.loader.java.type.ConfigurationElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.FunctionElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.api.loader.java.type.ParameterizableTypeElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ComponentWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ConfigurationWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.FunctionWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.OperationWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class ExtensionTypeWrapper<T>
extends ComponentWrapper
implements ExtensionElement,
ParameterizableTypeElement {
    private LazyValue<Extension> extensionAnnotation = new LazyValue<Supplier<Extension>>(() -> this.getAnnotation(Extension.class).get());

    public ExtensionTypeWrapper(Class<T> aClass, ClassTypeLoader typeLoader) {
        super(aClass, typeLoader);
    }

    @Override
    public List<ConfigurationElement> getConfigurations() {
        Optional<Configurations> optionalConfigurations = this.getAnnotation(Configurations.class);
        if (optionalConfigurations.isPresent()) {
            Configurations configurations = optionalConfigurations.get();
            return Stream.of(configurations.value()).map(aClass -> new ConfigurationWrapper((Class)aClass, this.typeLoader)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<OperationElement> getOperations() {
        return this.getAnnotation(Operations.class).map(classes -> Stream.of(classes.value()).flatMap(clazz -> IntrospectionUtils.getApiMethods(clazz).stream()).map(clazz -> new OperationWrapper((Method)clazz, this.typeLoader)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Override
    public List<FunctionElement> getFunctions() {
        return this.getAnnotation(ExpressionFunctions.class).map(classes -> Stream.of(classes.value()).flatMap(clazz -> IntrospectionUtils.getApiMethods(clazz).stream()).map(clazz -> new FunctionWrapper((Method)clazz, this.typeLoader)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Override
    public Category getCategory() {
        return this.extensionAnnotation.get().category();
    }

    @Override
    public String getVendor() {
        return this.extensionAnnotation.get().vendor();
    }

    @Override
    public String getName() {
        return this.extensionAnnotation.get().name();
    }
}

