/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.csv.writer;

import java.io.OutputStream;
import java.io.Serializable;
import org.mule.weave.v2.exception.WriterExecutionException;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ArraySeq;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.NullType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.values.ArrayValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.ConfigurableReaderWriter;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.csv.CSVDataFormat;
import org.mule.weave.v2.module.csv.reader.parser.CSVSettingsHelper;
import org.mule.weave.v2.module.csv.reader.parser.CSVWriterSettings;
import org.mule.weave.v2.module.csv.writer.CSVWriter$;
import org.mule.weave.v2.module.writer.BufferedIOWriter;
import org.mule.weave.v2.module.writer.BufferedIOWriter$;
import org.mule.weave.v2.module.writer.TargetProvider;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001B\u0001\u0003\u0001E\u0011\u0011bQ*W/JLG/\u001a:\u000b\u0005\r!\u0011AB<sSR,'O\u0003\u0002\u0006\r\u0005\u00191m\u001d<\u000b\u0005\u001dA\u0011AB7pIVdWM\u0003\u0002\n\u0015\u0005\u0011aO\r\u0006\u0003\u00171\tQa^3bm\u0016T!!\u0004\b\u0002\t5,H.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g!\tI2$D\u0001\u001b\u0015\t\u0019a!\u0003\u0002\u001d5\t1qK]5uKJD\u0001B\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\u0003_N\u0004\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\u0005%|'\"\u0001\u0013\u0002\t)\fg/Y\u0005\u0003M\u0005\u0012AbT;uaV$8\u000b\u001e:fC6D\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!K\u0001\tg\u0016$H/\u001b8hgV\t!\u0006\u0005\u0002,a5\tAF\u0003\u0002.]\u00051\u0001/\u0019:tKJT!a\f\u0003\u0002\rI,\u0017\rZ3s\u0013\t\tDFA\tD'Z;&/\u001b;feN+G\u000f^5oOND\u0001b\r\u0001\u0003\u0002\u0003\u0006IAK\u0001\ng\u0016$H/\u001b8hg\u0002B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006YAN\u0001\u0004GRD\bCA\u001c;\u001b\u0005A$BA\u001d\t\u0003\u0015iw\u000eZ3m\u0013\tY\u0004HA\tFm\u0006dW/\u0019;j_:\u001cuN\u001c;fqRDQ!\u0010\u0001\u0005\u0002y\na\u0001P5oSRtDcA D\tR\u0011\u0001I\u0011\t\u0003\u0003\u0002i\u0011A\u0001\u0005\u0006kq\u0002\u001dA\u000e\u0005\u0006=q\u0002\ra\b\u0005\u0006Qq\u0002\rA\u000b\u0005\t\u0007\u0001A)\u0019!C\u0001\rV\tq\t\u0005\u0002\u001a\u0011&\u0011\u0011J\u0007\u0002\u0011\u0005V4g-\u001a:fI&{uK]5uKJD\u0001b\u0013\u0001\t\u0006\u0004%\t\u0001T\u0001\nGN4Xi]2ba\u0016,\u0012!\u0014\t\u0003W9K!a\u0014\u0017\u0003#\r\u001bfkU3ui&twm\u001d%fYB,'\u000fC\u0003R\u0001\u0011\u0005#+\u0001\u0004sKN,H\u000e^\u000b\u0002'B\u00111\u0003V\u0005\u0003+R\u00111!\u00118z\u0011\u00159\u0006\u0001\"\u0015Y\u00031!wn\u0016:ji\u00164\u0016\r\\;f)\tIf\f\u0006\u0002[;B\u00111cW\u0005\u00039R\u0011A!\u00168ji\")QG\u0016a\u0002m!)qL\u0016a\u0001A\u0006)a/\u00197vKB\u0012\u0011-\u001b\t\u0004E\u0016<W\"A2\u000b\u0005\u0011D\u0014A\u0002<bYV,7/\u0003\u0002gG\n)a+\u00197vKB\u0011\u0001.\u001b\u0007\u0001\t%Qg,!A\u0001\u0002\u000b\u00051NA\u0002`IE\n\"\u0001\\*\u0011\u0005Mi\u0017B\u00018\u0015\u0005\u001dqu\u000e\u001e5j]\u001eDQ\u0001\u001d\u0001\u0005\u0002E\f1b\u001e:ji\u0016DU-\u00193feR\u0011!\u000f\u001e\u000b\u00035NDQ!N8A\u0004YBQaX8A\u0002U\u0004$A\u001e=\u0011\u0007\t,w\u000f\u0005\u0002iq\u0012I\u0011\u0010^A\u0001\u0002\u0003\u0015\ta\u001b\u0002\u0004?\u0012\u0012\u0004\"B>\u0001\t\u0003a\u0018\u0001C<sSR,7i\u0015,\u0015\u0005u|HC\u0001.\u007f\u0011\u0015)$\u0010q\u00017\u0011\u001d\t\tA\u001fa\u0001\u0003\u0007\t\u0001\"\u001b;fe\u0006$xN\u001d\t\u0007\u0003\u000b\t)\"a\u0007\u000f\t\u0005\u001d\u0011\u0011\u0003\b\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u0002\t\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0012bAA\n)\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\f\u00033\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003'!\u0002\u0007BA\u000f\u0003C\u0001BAY3\u0002 A\u0019\u0001.!\t\u0005\u0015\u0005\rr0!A\u0001\u0002\u000b\u00051NA\u0002`IMBq!a\n\u0001\t\u0003\tI#\u0001\u0006xe&$X-\u00128uef$B!a\u000b\u00020Q\u0019!,!\f\t\rU\n)\u0003q\u00017\u0011\u001dy\u0016Q\u0005a\u0001\u0003c\u0001D!a\r\u00028A!!-ZA\u001b!\rA\u0017q\u0007\u0003\f\u0003s\ty#!A\u0001\u0002\u000b\u00051NA\u0002`IUBq!!\u0010\u0001\t\u0003\ty$A\u0006xe&$XMU3d_J$G\u0003BA!\u0003\u000b\"2AWA\"\u0011\u0019)\u00141\ba\u0002m!A\u0011\u0011AA\u001e\u0001\u0004\t9\u0005\u0005\u0004\u0002\u0006\u0005U\u0011\u0011\n\t\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)\u0019\u0011q\n\u001d\u0002\u0013M$(/^2ukJ,\u0017\u0002BA*\u0003\u001b\u0012AbS3z-\u0006dW/\u001a)bSJDq!a\u0016\u0001\t\u0003\tI&A\u0005tKB\f'/\u0019;peV\u0011\u00111\f\t\u0004'\u0005u\u0013bAA0)\t!1\t[1s\u0011\u001d\t\u0019\u0007\u0001C!\u0003K\nQa\u00197pg\u0016$\u0012A\u0017\u0005\b\u0003S\u0002A\u0011IA3\u0003\u00151G.^:i\u0011\u001d\ti\u0007\u0001C!\u0003_\n!\u0002Z1uC\u001a{'/\\1u+\t\t\t\bE\u0003\u0014\u0003g\n9(C\u0002\u0002vQ\u0011aa\u00149uS>t\u0007GBA=\u0003\u0007\u000bI\t\u0005\u0005\u0002|\u0005u\u0014\u0011QAD\u001b\u00051\u0011bAA@\r\tQA)\u0019;b\r>\u0014X.\u0019;\u0011\u0007!\f\u0019\tB\u0006\u0002\u0006\u0006-\u0014\u0011!A\u0001\u0006\u0003Y'aA0%mA\u0019\u0001.!#\u0005\u0017\u0005-\u00151NA\u0001\u0002\u0003\u0015\ta\u001b\u0002\u0004?\u0012:taBAH\u0005!\u0005\u0011\u0011S\u0001\n\u0007N3vK]5uKJ\u00042!QAJ\r\u0019\t!\u0001#\u0001\u0002\u0016N\u0019\u00111\u0013\n\t\u000fu\n\u0019\n\"\u0001\u0002\u001aR\u0011\u0011\u0011\u0013\u0005\t\u0003;\u000b\u0019\n\"\u0001\u0002 \u0006)\u0011\r\u001d9msR1\u0011\u0011UAS\u0003_#2\u0001QAR\u0011\u0019)\u00141\u0014a\u0002m!A\u0011qUAN\u0001\u0004\tI+\u0001\u0002uaB\u0019\u0011$a+\n\u0007\u00055&D\u0001\bUCJ<W\r\u001e)s_ZLG-\u001a:\t\r!\nY\n1\u0001+\u0001")
public class CSVWriter
implements Writer {
    private BufferedIOWriter writer;
    private CSVSettingsHelper csvEscape;
    private final OutputStream os;
    private final CSVWriterSettings settings;
    private final EvaluationContext ctx;
    private volatile byte bitmap$0;

    public static CSVWriter apply(TargetProvider targetProvider, CSVWriterSettings cSVWriterSettings, EvaluationContext evaluationContext) {
        return CSVWriter$.MODULE$.apply(targetProvider, cSVWriterSettings, evaluationContext);
    }

    @Override
    public void startDocument(LocationCapable location) {
        Writer.startDocument$(this, location);
    }

    @Override
    public void defineNamespace(LocationCapable location, String prefix, String uri) {
        Writer.defineNamespace$(this, location, prefix, uri);
    }

    @Override
    public final void writeValue(Value<?> value, EvaluationContext ctx) {
        Writer.writeValue$(this, value, ctx);
    }

    @Override
    public String getName() {
        return Writer.getName$(this);
    }

    @Override
    public final void endDocument(LocationCapable location) {
        Writer.endDocument$(this, location);
    }

    @Override
    public void doEndDocument(LocationCapable location) {
        Writer.doEndDocument$(this, location);
    }

    @Override
    public void setOption(Location location, String optionName, Object value) {
        ConfigurableReaderWriter.setOption$(this, location, optionName, value);
    }

    @Override
    public CSVWriterSettings settings() {
        return this.settings;
    }

    private BufferedIOWriter writer$lzycompute() {
        CSVWriter cSVWriter = this;
        synchronized (cSVWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.writer = BufferedIOWriter$.MODULE$.apply(this.os, this.settings().charset(this.ctx), this.settings().bufferSize());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.ctx = null;
        return this.writer;
    }

    public BufferedIOWriter writer() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.writer$lzycompute() : this.writer;
    }

    private CSVSettingsHelper csvEscape$lzycompute() {
        CSVWriter cSVWriter = this;
        synchronized (cSVWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.csvEscape = new CSVSettingsHelper(this.settings());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.csvEscape;
    }

    public CSVSettingsHelper csvEscape() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.csvEscape$lzycompute() : this.csvEscape;
    }

    @Override
    public Object result() {
        return this.os;
    }

    @Override
    public void doWriteValue(Value<?> value, EvaluationContext ctx) {
        Value<?> value2 = value;
        if (value.valueType(ctx).isInstanceOf(ObjectType$.MODULE$, ctx)) {
            this.doWriteValue(ArrayValue$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Value[]{value2}))), ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (value.valueType(ctx).isInstanceOf(ArrayType$.MODULE$, ctx)) {
            this.writeCSV(((ArraySeq)ArrayType$.MODULE$.coerce(value2, ctx).evaluate(ctx)).toIterator(), ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new WriterExecutionException(value.location(), this.getName(), new StringBuilder(60).append("CSV Structure should be and Array<Object> or Object but got ").append(value.valueType(ctx)).toString());
        }
    }

    public void writeHeader(Value<?> value, EvaluationContext ctx) {
        ObjectSeq evaluate = (ObjectSeq)ObjectType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        BooleanRef first = BooleanRef.create((boolean)true);
        evaluate.toIterator(ctx).foreach((Function1 & Serializable & scala.Serializable)kvv -> {
            CSVWriter.$anonfun$writeHeader$1(this, ctx, first, kvv);
            return BoxedUnit.UNIT;
        });
        this.writer().write(this.settings().lineSeparator());
    }

    public void writeCSV(Iterator<Value<?>> iterator, EvaluationContext ctx) {
        boolean first = true;
        while (iterator.hasNext()) {
            Value value = (Value)iterator.next();
            if (this.settings().header() && first) {
                value = value.materialize(ctx);
                this.writeHeader(value, ctx);
            }
            this.writeRecord(((ObjectSeq)ObjectType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toIterator(ctx), ctx);
            first = false;
        }
    }

    public void writeEntry(Value<?> value, EvaluationContext ctx) {
        block4: {
            boolean quoteValues;
            Option<Object> quote = this.settings().quote();
            boolean bl = quoteValues = this.settings().quoteValues() && quote.isDefined();
            if (quoteValues) {
                this.writer().write(BoxesRunTime.unboxToChar((Object)quote.get()));
            }
            if (!value.valueType(ctx).isInstanceOf(NullType$.MODULE$, ctx)) {
                String stringValue = (String)StringType$.MODULE$.withSchema(value.valueType(ctx).schema(ctx)).coerce(value, ctx).evaluate(ctx);
                if (quoteValues) {
                    this.writer().write(this.csvEscape().escapeQuotedString(stringValue));
                } else {
                    this.writer().write(this.csvEscape().escapeUnquotedString(stringValue));
                }
            }
            if (!quoteValues) break block4;
            this.writer().write(BoxesRunTime.unboxToChar((Object)quote.get()));
        }
    }

    public void writeRecord(Iterator<KeyValuePair> iterator, EvaluationContext ctx) {
        int index = 0;
        while (iterator.hasNext()) {
            KeyValuePair kvp = (KeyValuePair)iterator.next();
            if (index > 0) {
                this.writer().write(this.separator());
            }
            this.writeEntry((Value<?>)kvp._2(), ctx);
            ++index;
        }
        this.writer().write(this.settings().lineSeparator());
    }

    public char separator() {
        return this.settings().separator();
    }

    @Override
    public void close() {
        this.writer().close();
    }

    @Override
    public void flush() {
        this.writer().flush();
    }

    @Override
    public Option<DataFormat<?, ?>> dataFormat() {
        return new Some((Object)new CSVDataFormat());
    }

    public static final /* synthetic */ void $anonfun$writeHeader$1(CSVWriter $this, EvaluationContext ctx$1, BooleanRef first$1, KeyValuePair kvv) {
        String name = ((QualifiedName)kvv._1().evaluate(ctx$1)).name();
        if (!first$1.elem) {
            $this.writer().write($this.separator());
        }
        if ($this.settings().quoteHeader()) {
            $this.writer().write(new StringBuilder(2).append("\"").append(name).append("\"").toString());
        } else {
            $this.writer().write(name);
        }
        first$1.elem = false;
    }

    public CSVWriter(OutputStream os, CSVWriterSettings settings, EvaluationContext ctx) {
        this.os = os;
        this.settings = settings;
        this.ctx = ctx;
        ConfigurableReaderWriter.$init$(this);
        Writer.$init$(this);
    }
}

