/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.internal.event.EventQuickCopy;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;

public class PolicyEventMapper {
    private static final String POLICY_VARS = "policy.vars.%s";
    private static final String POLICY_SOURCE_ORIGINAL_EVENT = "policy.source.originalEvent";
    private static final String POLICY_OPERATION_ORIGINAL_EVENT = "policy.operation.originalEvent";
    private final String policyId;

    public PolicyEventMapper() {
        this(null);
    }

    public PolicyEventMapper(String policyId) {
        this.policyId = policyId;
    }

    public CoreEvent onSourcePolicyBegin(CoreEvent event) {
        return InternalEvent.builder(event).addInternalParameter(POLICY_SOURCE_ORIGINAL_EVENT, event).clearVariables().build();
    }

    public CoreEvent onOperationPolicyBegin(CoreEvent event) {
        Map<String, TypedValue<?>> variables = this.loadVars(event);
        return InternalEvent.builder(event).addInternalParameter(POLICY_OPERATION_ORIGINAL_EVENT, event).variablesTyped(variables != null ? variables : Collections.emptyMap()).build();
    }

    public CoreEvent onOperationPolicyFinish(CoreEvent result, boolean propagate) {
        InternalEvent operationResult = (InternalEvent)((InternalEvent)result).getInternalParameter("policy.operation.nextOperationResponse");
        if (operationResult == null) {
            return InternalEvent.builder(result).addInternalParameter(this.policyVarsInternalParameterName(), result.getVariables()).variablesTyped(this.getOperationOriginalEvent(result).getVariables()).build();
        }
        Message message = propagate ? result.getMessage() : operationResult.getMessage();
        CoreEvent next = CoreEvent.builder(result).message(message).variables(operationResult.getVariables()).build();
        return EventQuickCopy.quickCopy(next, (Map<String, Object>)ImmutableMap.of((Object)this.policyVarsInternalParameterName(), result.getVariables(), (Object)"policy.operation.nextOperationResponse", (Object)next));
    }

    public CoreEvent onOperationPolicyError(CoreEvent result) {
        InternalEvent nextOperationResponse = (InternalEvent)((InternalEvent)result).getInternalParameter("policy.operation.nextOperationResponse");
        if (nextOperationResponse == null) {
            return InternalEvent.builder(result).addInternalParameter(this.policyVarsInternalParameterName(), result.getVariables()).variablesTyped(this.getOperationOriginalEvent(result).getVariables()).build();
        }
        return InternalEvent.builder(result).addInternalParameter(this.policyVarsInternalParameterName(), result.getVariables()).addInternalParameter("policy.operation.nextOperationResponse", nextOperationResponse).variablesTyped(nextOperationResponse.getVariables()).build();
    }

    public CoreEvent onSourcePolicyNext(CoreEvent event, boolean propagate) {
        return this.onPolicyNext(event, propagate);
    }

    public CoreEvent onOperationPolicyNext(CoreEvent event) {
        return this.onPolicyNext(event, true);
    }

    public CoreEvent fromPolicyNext(CoreEvent event) {
        Map<String, TypedValue<?>> variables = this.loadVars(event);
        return InternalEvent.builder(event).variablesTyped(variables != null ? variables : Collections.emptyMap()).build();
    }

    public CoreEvent onFlowFinish(CoreEvent flowResult, Optional<SourcePolicyParametersTransformer> parametersTransformer) {
        Map<String, Object> originalResponseParameters = this.getResponseParamsProcessor(flowResult).getSuccessfulExecutionResponseParametersFunction().apply(flowResult);
        Message message = parametersTransformer.map(t -> t.fromSuccessResponseParametersToMessage(originalResponseParameters)).orElseGet(flowResult::getMessage);
        return InternalEvent.builder(flowResult).message(message).addInternalParameter("policy.source.originalResponseParameters", originalResponseParameters).build();
    }

    public CoreEvent onFlowError(CoreEvent event, String policyId, Optional<SourcePolicyParametersTransformer> parametersTransformer) {
        Map<String, Object> originalFailureResponseParameters = this.getResponseParamsProcessor(event).getFailedExecutionResponseParametersFunction().apply(event);
        Message message = parametersTransformer.map(t -> t.fromFailureResponseParametersToMessage(originalFailureResponseParameters)).orElse(event.getMessage());
        Map<String, TypedValue<?>> variables = this.loadVars(event, policyId);
        return InternalEvent.builder(event).message(message).addInternalParameter("policy.source.originalFailureResponseParameters", originalFailureResponseParameters).variablesTyped(variables != null ? variables : Collections.emptyMap()).build();
    }

    private CoreEvent onPolicyNext(CoreEvent event, boolean propagate) {
        Set eventCtxIds = (Set)((InternalEvent)event).getInternalParameter("policy.next.eventCtxIds");
        PrivilegedEvent originalEvent = this.getOriginalEvent(event);
        return InternalEvent.builder(event).message(propagate ? event.getMessage() : originalEvent.getMessage()).variables((Map)originalEvent.getVariables()).addInternalParameter(this.policyVarsInternalParameterName(), event.getVariables()).addInternalParameter("policy.next.eventCtxIds", eventCtxIds == null ? Collections.singleton(event.getContext().getId()) : ImmutableSet.builder().addAll((Iterable)eventCtxIds).add((Object)event.getContext().getId()).build()).build();
    }

    private String policyVarsInternalParameterName() {
        return String.format(POLICY_VARS, this.policyId);
    }

    private String policyVarsInternalParameterName(String policyId) {
        return String.format(POLICY_VARS, policyId);
    }

    private PrivilegedEvent getOriginalEvent(CoreEvent event) {
        PrivilegedEvent operationOriginalEvent = this.getOperationOriginalEvent(event);
        return operationOriginalEvent != null ? operationOriginalEvent : this.getSourceOriginalEvent(event);
    }

    private PrivilegedEvent getOperationOriginalEvent(CoreEvent event) {
        return (PrivilegedEvent)((InternalEvent)event).getInternalParameter(POLICY_OPERATION_ORIGINAL_EVENT);
    }

    private PrivilegedEvent getSourceOriginalEvent(CoreEvent event) {
        return (PrivilegedEvent)((InternalEvent)event).getInternalParameter(POLICY_SOURCE_ORIGINAL_EVENT);
    }

    private Map<String, TypedValue<?>> loadVars(CoreEvent event) {
        return (Map)((InternalEvent)event).getInternalParameter(this.policyVarsInternalParameterName());
    }

    private Map<String, TypedValue<?>> loadVars(CoreEvent event, String policyId) {
        return (Map)((InternalEvent)event).getInternalParameter(this.policyVarsInternalParameterName(policyId));
    }

    private MessageSourceResponseParametersProcessor getResponseParamsProcessor(CoreEvent event) {
        return (MessageSourceResponseParametersProcessor)((InternalEvent)event).getInternalParameter("policy.source.parametersProcessor");
    }
}

