/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.expression;

import java.nio.charset.Charset;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.internal.transformer.expression.AbstractExpressionTransformer;
import org.mule.runtime.core.internal.transformer.expression.ExpressionArgument;

public class ExpressionTransformer
extends AbstractExpressionTransformer {
    private boolean returnSourceIfNull = false;

    @Override
    public Object transformMessage(CoreEvent event, Charset outputEncoding) throws MessageTransformerException {
        Object[] results = new Object[this.arguments.size()];
        int i = 0;
        for (ExpressionArgument argument : this.arguments) {
            try {
                results[i] = argument.evaluate(event);
            }
            catch (ExpressionRuntimeException e) {
                throw new MessageTransformerException(this, e, event.getMessage());
            }
            if (!argument.isOptional() && results[i] == null) {
                throw new MessageTransformerException(CoreMessages.expressionReturnedNull(argument.getExpression()), this, event.getMessage());
            }
            ++i;
        }
        if (this.isReturnSourceIfNull() && this.checkIfAllAreNull(results)) {
            return event.getMessage();
        }
        if (results.length == 1) {
            return results[0];
        }
        return results;
    }

    private boolean checkIfAllAreNull(Object[] objects) {
        for (Object object : objects) {
            if (object == null) continue;
            return false;
        }
        return true;
    }

    public boolean isReturnSourceIfNull() {
        return this.returnSourceIfNull;
    }

    public void setReturnSourceIfNull(boolean returnSourceIfNull) {
        this.returnSourceIfNull = returnSourceIfNull;
    }
}

