/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.transformer;

import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.privileged.transformer.ExtendedTransformationService;

public final class CompositeConverter
extends AbstractComponent
implements Converter,
MuleContextAware {
    private final String name;
    private final LinkedList<Converter> chain;
    private MuleContext muleContext;

    public CompositeConverter(Converter ... converters) {
        if (converters.length == 0) {
            throw new IllegalArgumentException("There must be at least one converter");
        }
        this.chain = new LinkedList();
        this.name = this.compositeConverterName(converters);
    }

    private String compositeConverterName(Converter[] converters) {
        StringBuilder builder = new StringBuilder();
        for (Converter converter : converters) {
            this.chain.addLast(converter);
            builder.append(converter.getName());
        }
        return builder.toString();
    }

    @Override
    public boolean isSourceDataTypeSupported(DataType dataType) {
        return this.chain.size() > 0 && this.chain.peekFirst().isSourceDataTypeSupported(dataType);
    }

    @Override
    public List<DataType> getSourceDataTypes() {
        return this.chain.peekFirst().getSourceDataTypes();
    }

    @Override
    public boolean isAcceptNull() {
        return this.chain.size() > 0 && this.chain.peekFirst().isAcceptNull();
    }

    @Override
    public boolean isIgnoreBadInput() {
        return this.chain.size() > 0 && this.chain.peekFirst().isIgnoreBadInput();
    }

    @Override
    public Object transform(Object src) throws TransformerException {
        return this.transform(src, null);
    }

    @Override
    public Object transform(Object src, Charset encoding) throws TransformerException {
        Object current = src;
        Charset currentEncoding = encoding;
        for (Converter converter : this.chain) {
            current = currentEncoding != null ? converter.transform(current, currentEncoding) : converter.transform(current);
            currentEncoding = converter.getReturnDataType().getMediaType().getCharset().orElse(encoding);
        }
        return current;
    }

    @Override
    public void setReturnDataType(DataType type) {
        this.chain.peekLast().setReturnDataType(type);
    }

    @Override
    public DataType getReturnDataType() {
        return this.chain.peekLast().getReturnDataType();
    }

    @Override
    public void dispose() {
        for (Converter converter : this.chain) {
            converter.dispose();
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        for (Converter converter : this.chain) {
            converter.initialise();
        }
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        if (event != null && event.getMessage() != null) {
            try {
                event = CoreEvent.builder(event).message(((ExtendedTransformationService)this.muleContext.getTransformationService()).applyTransformers(event.getMessage(), event, this)).build();
            }
            catch (MessageTransformerException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageTransformerException(this, e, event.getMessage());
            }
        }
        return event;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        for (Converter converter : this.chain) {
            converter.setMuleContext(context);
        }
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException("Cannot change composite converter name");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPriorityWeighting() {
        int priorityWeighting = 0;
        for (Converter converter : this.chain) {
            priorityWeighting += converter.getPriorityWeighting();
        }
        return priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int weighting) {
    }

    public LinkedList<Converter> getConverters() {
        return new LinkedList<Converter>(this.chain);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name: " + this.getName() + "; chain: " + this.getConverters().toString() + "]";
    }
}

