/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.utils;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.URI;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;

public class UriCache {
    private static final int MAX_CACHE_SIZE = 2000;
    private static volatile UriCache instance;
    private Cache<String, URI> cache = Caffeine.newBuilder().maximumSize(2000L).build();

    private UriCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UriCache getInstance() {
        if (instance != null) return instance;
        Class<UriCache> clazz = UriCache.class;
        synchronized (UriCache.class) {
            if (instance != null) return instance;
            instance = new UriCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static URI getUriFromString(String uri) {
        try {
            return (URI)UriCache.getInstance().cache.get((Object)uri, u -> URI.create(u));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create URI for " + uri, e));
        }
    }
}

