/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.transaction;

import java.util.Optional;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.privileged.transaction.TransactionAdapter;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionKey;
import org.mule.runtime.module.extension.internal.runtime.transaction.TransactionBindingDelegate;

public class TransactionSourceBinder {
    private final ExtensionModel extensionModel;
    private final ComponentModel componentModel;
    private final MuleContext muleContext;
    private final TransactionBindingDelegate transactionBindingDelegate;

    public TransactionSourceBinder(ExtensionModel extensionModel, ComponentModel componentModel, MuleContext muleContext) {
        this.extensionModel = extensionModel;
        this.componentModel = componentModel;
        this.muleContext = muleContext;
        this.transactionBindingDelegate = new TransactionBindingDelegate(extensionModel, componentModel);
    }

    public <T extends TransactionalConnection> Optional<ConnectionHandler<T>> bindToTransaction(TransactionConfig transactionConfig, ConfigurationInstance configurationInstance, ComponentLocation sourceLocation, ConnectionHandler connectionHandler) throws ConnectionException, TransactionException {
        if (!transactionConfig.isTransacted()) {
            return Optional.empty();
        }
        Transaction tx = transactionConfig.getFactory().beginTransaction(this.muleContext);
        ((TransactionAdapter)tx).setComponentLocation(sourceLocation);
        tx.setTimeout(transactionConfig.getTimeout());
        ConfigurationInstance configuration = Optional.ofNullable(configurationInstance).orElseThrow(() -> new IllegalStateException(String.format("Source '%s' of extension '%s' cannot participate in a transaction because it doesn't have a config", this.componentModel.getName(), this.extensionModel.getName())));
        ExtensionTransactionKey txKey = new ExtensionTransactionKey(configuration);
        return Optional.of(this.transactionBindingDelegate.getBoundResource(transactionConfig, txKey, () -> connectionHandler));
    }
}

