/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.reduced;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Stack;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.persistence.AbstractJsonMetadataTypeWriter;
import org.mule.metadata.persistence.MetadataSerializingException;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;
import org.mule.metadata.persistence.reduced.CatalogTypeCollectorMetadataTypeVisitor;
import org.mule.metadata.persistence.reduced.InnerCatalogObjectTypeReferenceHandler;
import org.mule.metadata.persistence.serializer.ObjectTypeSerializer;
import org.mule.metadata.persistence.serializer.TypeSerializerVisitor;

public class ReducedJsonMetadataTypeWriter
extends AbstractJsonMetadataTypeWriter {
    private final ObjectTypeReferenceHandler referenceHandler = new InnerCatalogObjectTypeReferenceHandler();

    @Override
    protected void write(MetadataType type) throws IOException {
        CatalogTypeCollectorMetadataTypeVisitor collector = new CatalogTypeCollectorMetadataTypeVisitor();
        type.accept(collector);
        this.writer.beginObject().name("value");
        this.writeModel(type);
        this.writeCatalog(this.writer, collector.getCatalog());
        this.writer.endObject();
    }

    private void writeModel(final MetadataType type) {
        type.accept(new MetadataTypeVisitor(){

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                type.accept(new TypeSerializerVisitor(ReducedJsonMetadataTypeWriter.this.writer, ReducedJsonMetadataTypeWriter.this.referenceHandler, ReducedJsonMetadataTypeWriter.this.typeStack, false));
            }
        });
    }

    private void writeCatalog(JsonWriter writer, Map<String, ObjectType> registeredTypes) throws IOException {
        if (!registeredTypes.isEmpty()) {
            writer.name("catalog");
            writer.beginObject();
            registeredTypes.forEach((id, type) -> {
                try {
                    writer.name(id);
                    TypeSerializerVisitor visitor = new TypeSerializerVisitor(writer, this.referenceHandler, new Stack<MetadataType>(), false);
                    new ObjectTypeSerializer(visitor).serialize(writer, type, this.typeStack);
                }
                catch (IOException e) {
                    throw new MetadataSerializingException("Object MetadataType for catalog");
                }
            });
            writer.endObject();
        }
    }

    @Override
    public ReducedJsonMetadataTypeWriter setPrettyPrint(boolean prettyPrint) {
        super.setPrettyPrint(prettyPrint);
        return this;
    }
}

