/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.internal.util.FileJarExplorer;
import org.mule.runtime.module.artifact.internal.util.JarInfo;
import org.mule.runtime.module.deployment.impl.internal.maven.MavenUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ArtifactClassLoaderModelBuilder
extends ClassLoaderModel.ClassLoaderModelBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactClassLoaderModelBuilder.class);
    private static final String GROUP_ID = "groupId";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String VERSION = "version";
    protected static final String MULE_PLUGIN = "mule-plugin";
    private boolean processSharedLibraries = false;
    private boolean processAdditionalPluginLibraries = false;
    protected FileJarExplorer fileJarExplorer = new FileJarExplorer();
    protected File artifactFolder;
    protected ArtifactDescriptor deployableArtifactDescriptor;
    protected BundleDescriptor artifactBundleDescriptor;

    public ArtifactClassLoaderModelBuilder(File artifactFolder, BundleDescriptor artifactBundleDescriptor) {
        Objects.requireNonNull(artifactFolder, "artifactFolder cannot be null");
        Objects.requireNonNull(artifactBundleDescriptor, "artifactBundleDescriptor cannot be null");
        this.artifactBundleDescriptor = artifactBundleDescriptor;
        this.artifactFolder = artifactFolder;
    }

    public ClassLoaderModel.ClassLoaderModelBuilder exportingSharedLibraries() {
        this.processSharedLibraries = true;
        return this;
    }

    public ClassLoaderModel.ClassLoaderModelBuilder additionalPluginLibraries() {
        this.processAdditionalPluginLibraries = true;
        return this;
    }

    public void setDeployableArtifactDescriptor(ArtifactDescriptor deployableArtifactDescriptor) {
        this.deployableArtifactDescriptor = deployableArtifactDescriptor;
    }

    @Override
    public ClassLoaderModel build() {
        Optional<Object> pluginOptional = Optional.empty();
        if (this.processSharedLibraries || this.processAdditionalPluginLibraries) {
            pluginOptional = this.findMuleMavenPluginDeclaration();
        }
        if (this.processSharedLibraries) {
            pluginOptional.ifPresent(this::exportSharedLibrariesResourcesAndPackages);
        }
        if (this.processAdditionalPluginLibraries) {
            pluginOptional.ifPresent(this::processAdditionalPluginLibraries);
        }
        return super.build();
    }

    private Optional<Plugin> findMuleMavenPluginDeclaration() {
        Model model = MavenUtils.getPomModelFolder(this.artifactFolder);
        return this.findArtifactPackagerPlugin(model);
    }

    protected Optional<Plugin> findArtifactPackagerPlugin(Model model) {
        List plugins;
        Build build = model.getBuild();
        if (build != null && (plugins = build.getPlugins()) != null) {
            return plugins.stream().filter(plugin -> plugin.getArtifactId().equals("mule-maven-plugin") && plugin.getGroupId().equals("org.mule.tools.maven") || plugin.getArtifactId().equals("mule-extensions-maven-plugin") && plugin.getGroupId().equals("org.mule.runtime.plugins")).findFirst();
        }
        return Optional.empty();
    }

    private void exportSharedLibrariesResourcesAndPackages(Plugin packagingPlugin) {
        this.doExportSharedLibrariesResourcesAndPackages(packagingPlugin);
    }

    private void processAdditionalPluginLibraries(Plugin packagingPlugin) {
        Map<BundleDescriptor, Set<BundleDescriptor>> pluginsWithAdditionalLibraries = this.doProcessAdditionalPluginLibraries(packagingPlugin);
        pluginsWithAdditionalLibraries.entrySet().forEach(entry -> {
            BundleDescriptor pluginBundleDescriptor = (BundleDescriptor)entry.getKey();
            Set pluginAdditionalLibraries = (Set)entry.getValue();
            this.findBundleDependency(pluginBundleDescriptor.getGroupId(), pluginBundleDescriptor.getArtifactId(), Optional.of(MULE_PLUGIN)).ifPresent(pluginArtifactBundleDependency -> this.replaceBundleDependency((BundleDependency)pluginArtifactBundleDependency, new BundleDependency.Builder((BundleDependency)pluginArtifactBundleDependency).setAdditionalDependencies(pluginAdditionalLibraries.stream().map(additionalDependency -> new BundleDependency.Builder().setDescriptor((BundleDescriptor)additionalDependency).build()).collect(Collectors.toSet())).build()));
        });
    }

    protected Map<BundleDescriptor, Set<BundleDescriptor>> doProcessAdditionalPluginLibraries(Plugin packagingPlugin) {
        Xpp3Dom[] plugins;
        Xpp3Dom additionalPluginDependenciesDom;
        HashMap<BundleDescriptor, Set<BundleDescriptor>> pluginsAdditionalLibraries = new HashMap<BundleDescriptor, Set<BundleDescriptor>>();
        Object configuration = packagingPlugin.getConfiguration();
        if (configuration != null && (additionalPluginDependenciesDom = ((Xpp3Dom)configuration).getChild("additionalPluginDependencies")) != null && (plugins = additionalPluginDependenciesDom.getChildren("plugin")) != null) {
            for (Xpp3Dom plugin : plugins) {
                String pluginGroupId = this.getAttribute(plugin, GROUP_ID);
                String pluginArtifactId = this.getAttribute(plugin, ARTIFACT_ID);
                BundleDescriptor mulePluginDescriptor = new BundleDescriptor.Builder().setGroupId(pluginGroupId).setArtifactId(pluginArtifactId).setVersion("-").build();
                HashSet<BundleDescriptor> mulePluginAdditionalLibraries = new HashSet<BundleDescriptor>();
                Xpp3Dom dependenciesDom = plugin.getChild("additionalDependencies");
                if (dependenciesDom != null) {
                    for (Xpp3Dom dependency : dependenciesDom.getChildren("dependency")) {
                        String dependencyGroupId = this.getAttribute(dependency, GROUP_ID);
                        String dependencyArtifactId = this.getAttribute(dependency, ARTIFACT_ID);
                        String dependencyVersion = this.getAttribute(dependency, VERSION);
                        mulePluginAdditionalLibraries.add(new BundleDescriptor.Builder().setGroupId(dependencyGroupId).setArtifactId(dependencyArtifactId).setVersion(dependencyVersion).build());
                    }
                }
                pluginsAdditionalLibraries.put(mulePluginDescriptor, mulePluginAdditionalLibraries);
            }
        }
        return pluginsAdditionalLibraries;
    }

    protected void replaceBundleDependency(BundleDependency original, BundleDependency modified) {
        this.dependencies.remove(original);
        this.dependencies.add(modified);
    }

    protected void doExportSharedLibrariesResourcesAndPackages(Plugin packagingPlugin) {
        Xpp3Dom[] sharedLibraries;
        Xpp3Dom sharedLibrariesDom;
        Object configuration = packagingPlugin.getConfiguration();
        if (configuration != null && (sharedLibrariesDom = ((Xpp3Dom)configuration).getChild("sharedLibraries")) != null && (sharedLibraries = sharedLibrariesDom.getChildren("sharedLibrary")) != null) {
            for (Xpp3Dom sharedLibrary : sharedLibraries) {
                String artifactId;
                String groupId = this.getAttribute(sharedLibrary, GROUP_ID);
                if (this.validateMuleRuntimeSharedLibrary(groupId, artifactId = this.getAttribute(sharedLibrary, ARTIFACT_ID))) continue;
                this.findAndExportSharedLibrary(groupId, artifactId);
            }
        }
    }

    protected final boolean validateMuleRuntimeSharedLibrary(String groupId, String artifactId) {
        if ("org.mule.runtime".equals(groupId) || "com.mulesoft.mule.runtime.modules".equals(groupId)) {
            LOGGER.warn("Shared library '{}:{}' is a Mule Runtime dependency. It will not be shared by the app in order to avoid classloading issues. Please consider removing it, or at least not putting it as a sharedLibrary.", (Object)groupId, (Object)artifactId);
            return true;
        }
        return false;
    }

    protected String getAttribute(Xpp3Dom tag, String attributeName) {
        Xpp3Dom attributeDom = tag.getChild(attributeName);
        Preconditions.checkState(attributeDom != null, String.format("'%s' element not declared at '%s' in the pom file of the artifact '%s'", attributeName, tag.toString(), this.artifactFolder.getName()));
        String attributeValue = attributeDom.getValue().trim();
        Preconditions.checkState(!StringUtils.isEmpty((CharSequence)attributeValue), String.format("'%s' was defined but has an empty value at '%s' declared in the pom file of the artifact %s", attributeName, tag.toString(), this.artifactFolder.getName()));
        return attributeValue;
    }

    protected void findAndExportSharedLibrary(String groupId, String artifactId) {
        Optional<BundleDependency> bundleDependencyOptional = this.findBundleDependency(groupId, artifactId, Optional.empty());
        BundleDependency bundleDependency = bundleDependencyOptional.orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Dependency %s:%s could not be found within the artifact %s. It must be declared within the maven dependencies of the artifact.", groupId, artifactId, this.artifactFolder.getName()))));
        JarInfo jarInfo = this.fileJarExplorer.explore(bundleDependency.getBundleUri());
        this.exportingPackages(jarInfo.getPackages());
        this.exportingResources(jarInfo.getResources());
    }

    protected Optional<BundleDependency> findBundleDependency(String groupId, String artifactId, Optional<String> classifierOptional) {
        return this.dependencies.stream().filter(bundleDependency -> bundleDependency.getDescriptor().getArtifactId().equals(artifactId) && bundleDependency.getDescriptor().getGroupId().equals(groupId) && classifierOptional.map(classifier -> classifier.equals(bundleDependency.getDescriptor().getClassifier().orElse(null))).orElse(true) != false).findFirst();
    }

    public void includeAdditionalPluginDependencies() {
        if (this.deployableArtifactDescriptor != null) {
            this.deployableArtifactDescriptor.getClassLoaderModel().getDependencies().stream().filter(bundleDescriptor -> bundleDescriptor.getDescriptor().isPlugin()).filter(bundleDescriptor -> bundleDescriptor.getDescriptor().getGroupId().equals(this.artifactBundleDescriptor.getGroupId()) && bundleDescriptor.getDescriptor().getArtifactId().equals(this.artifactBundleDescriptor.getArtifactId())).filter(bundleDependency -> bundleDependency.getAdditionalDependencies() != null && !bundleDependency.getAdditionalDependencies().isEmpty()).forEach(bundleDependency -> this.processPluginAdditionalDependenciesURIs((BundleDependency)bundleDependency).forEach(uri -> {
                try {
                    this.containing(uri.toURL());
                }
                catch (MalformedURLException e) {
                    throw new ArtifactDescriptorCreateException(String.format("There was an exception obtaining the URL for the artifact [%s], file [%s]", this.artifactFolder.getAbsolutePath(), uri), e);
                }
            }));
        }
    }

    protected abstract List<URI> processPluginAdditionalDependenciesURIs(BundleDependency var1);
}

