/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.util.Arrays;
import java.util.Collection;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.deployment.api.ArtifactDeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentListener;

public class DeploymentListenerAdapter
implements DeploymentListener {
    private static final Collection<ArtifactType> DEPLOYMENT_LISTENER_ARTIFACT_SUPPORTED_TYPES = Arrays.asList(ArtifactType.DOMAIN, ArtifactType.APP);
    public static final String UNSUPPORTED_ARTIFACT_TYPE_ERROR = String.format("DeploymentListener only supports %s artifact types.", DEPLOYMENT_LISTENER_ARTIFACT_SUPPORTED_TYPES);
    private final ArtifactDeploymentListener artifactDeploymentListener;
    private final ArtifactType artifactType;

    public DeploymentListenerAdapter(ArtifactDeploymentListener artifactDeploymentListener, ArtifactType artifactType) {
        Preconditions.checkArgument(DEPLOYMENT_LISTENER_ARTIFACT_SUPPORTED_TYPES.contains((Object)artifactType), UNSUPPORTED_ARTIFACT_TYPE_ERROR);
        this.artifactType = artifactType;
        this.artifactDeploymentListener = artifactDeploymentListener;
    }

    @Override
    public void onDeploymentStart(String artifactName) {
        this.artifactDeploymentListener.onDeploymentStart(this.artifactType, artifactName);
    }

    @Override
    public void onDeploymentSuccess(String artifactName) {
        this.artifactDeploymentListener.onDeploymentSuccess(this.artifactType, artifactName);
    }

    @Override
    public void onDeploymentFailure(String artifactName, Throwable cause) {
        this.artifactDeploymentListener.onDeploymentFailure(this.artifactType, artifactName, cause);
    }

    @Override
    public void onUndeploymentStart(String artifactName) {
        this.artifactDeploymentListener.onUndeploymentStart(this.artifactType, artifactName);
    }

    @Override
    public void onUndeploymentSuccess(String artifactName) {
        this.artifactDeploymentListener.onUndeploymentSuccess(this.artifactType, artifactName);
    }

    @Override
    public void onUndeploymentFailure(String artifactName, Throwable cause) {
        this.artifactDeploymentListener.onUndeploymentFailure(this.artifactType, artifactName, cause);
    }

    @Override
    public void onArtifactCreated(String artifactName, CustomizationService customizationService) {
        this.artifactDeploymentListener.onArtifactCreated(this.artifactType, artifactName, customizationService);
    }

    @Override
    public void onArtifactInitialised(String artifactName, Registry registry) {
        this.artifactDeploymentListener.onArtifactInitialised(this.artifactType, artifactName, registry);
    }
}

