/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher.stereotypes;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NestableElementDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedChainDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedRouteDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithAllowedStereotypesDeclaration;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.annotation.param.stereotype.AllowedStereotypes;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.stereotype.StereotypeDefinition;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.enricher.stereotypes.ClassStereotypeResolver;
import org.mule.runtime.module.extension.internal.loader.enricher.stereotypes.StereotypeResolver;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.MethodWrapper;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;

class MethodStereotypeResolver
extends StereotypeResolver<MethodElement> {
    private final MethodWrapper methodElement;

    public MethodStereotypeResolver(MethodWrapper methodElement, ComponentDeclaration declaration, String namespace, StereotypeModel fallbackStereotype, Map<StereotypeDefinition, StereotypeModel> stereotypesCache) {
        super(methodElement, declaration, namespace, fallbackStereotype, stereotypesCache);
        this.methodElement = methodElement;
    }

    @Override
    protected void resolveStereotype() {
        super.resolveStereotype();
        this.addAllowedStereotypes(this.namespace, (ComponentDeclaration)this.declaration, this.methodElement);
    }

    @Override
    protected void addFallbackStereotype() {
        new ClassStereotypeResolver((Type)((MethodElement)this.annotatedElement).getEnclosingType(), this.declaration, this.namespace, this.fallbackStereotype, (Map<StereotypeDefinition, StereotypeModel>)this.stereotypesCache).resolveStereotype();
    }

    private void addAllowedStereotypes(String namespace, ComponentDeclaration<?> declaration, MethodElement methodElement) {
        Map<String, NestableElementDeclaration> nested = declaration.getNestedComponents().stream().collect(Collectors.toMap(NamedDeclaration::getName, n -> n));
        methodElement.getParameters().stream().filter(p -> nested.containsKey(p.getAlias())).forEach(parameter -> {
            if (ModelLoaderUtils.isProcessorChain(parameter)) {
                this.addAllowedStereotypes(namespace, (ExtensionParameter)parameter, (WithAllowedStereotypesDeclaration)nested.get(parameter.getAlias()));
            } else if (ModelLoaderUtils.isRoute(parameter)) {
                NestedRouteDeclaration route = (NestedRouteDeclaration)nested.get(parameter.getAlias());
                Optional<AllowedStereotypes> allowedStereotypes = parameter.getType().getAnnotation(AllowedStereotypes.class);
                allowedStereotypes.ifPresent(processorsStereotypes -> {
                    NestableElementDeclaration processorsChain = route.getNestedComponents().stream().filter(routeChild -> routeChild instanceof NestedChainDeclaration).findFirst().orElseThrow(() -> new IllegalStateException("Missing Chain component in Route declaration"));
                    this.addAllowedStereotypes((WithAllowedStereotypesDeclaration)((Object)processorsChain), processorsStereotypes.value(), namespace);
                });
            }
        });
    }

    private void addAllowedStereotypes(WithAllowedStereotypesDeclaration declaration, Class<? extends StereotypeDefinition>[] stereotypes, String namespace) {
        for (Class<? extends StereotypeDefinition> definition : stereotypes) {
            declaration.addAllowedStereotype(MethodStereotypeResolver.createCustomStereotype(definition, namespace, this.stereotypesCache));
        }
    }

    private void addAllowedStereotypes(String namespace, ExtensionParameter parameter, WithAllowedStereotypesDeclaration declaration) {
        Optional<AllowedStereotypes> allowedStereotypes = parameter.getAnnotation(AllowedStereotypes.class);
        if (allowedStereotypes.isPresent()) {
            this.addAllowedStereotypes(declaration, allowedStereotypes.get().value(), namespace);
        } else {
            declaration.addAllowedStereotype(MuleStereotypes.PROCESSOR);
        }
    }

    @Override
    protected <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return (T)((Annotation)((MethodElement)this.annotatedElement).getAnnotation(annotationType).orElse(null));
    }

    @Override
    protected String resolveDescription() {
        return "Method '" + ((MethodElement)this.annotatedElement).getName() + "'";
    }
}

