/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client.strategy;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.module.extension.internal.runtime.client.strategy.CachedExtensionsClientProcessorsStrategy;
import org.mule.runtime.module.extension.internal.runtime.client.strategy.ExtensionsClientProcessorsStrategy;
import org.mule.runtime.module.extension.internal.runtime.client.strategy.NonCachedExtensionsClientProcessorsStrategy;
import org.mule.runtime.module.extension.internal.runtime.client.strategy.OperationMessageProcessorUtils;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class ExtensionsClientProcessorsStrategyFactory
implements Initialisable,
Disposable {
    private static int MAX_CACHE_SIZE = 100;
    private static int CACHE_ENTRY_EXPIRE_AFTER_ACCESS_IN_MINUTES = 10;
    private boolean usesCachedStrategy;
    private Cache<String, OperationMessageProcessor> operationMessageProcessorCache;
    @Inject
    private ExtensionManager extensionManager;
    @Inject
    private Registry registry;
    @Inject
    private MuleContext muleContext;
    @Inject
    private PolicyManager policyManager;
    @Inject
    private ReflectionCache reflectionCache;

    public ExtensionsClientProcessorsStrategy create(CoreEvent event) {
        return this.usesCachedStrategy ? new CachedExtensionsClientProcessorsStrategy(this.extensionManager, this.registry, this.muleContext, this.policyManager, this.reflectionCache, event, this.operationMessageProcessorCache) : new NonCachedExtensionsClientProcessorsStrategy(this.extensionManager, this.registry, this.muleContext, this.policyManager, this.reflectionCache, event);
    }

    @Override
    public void initialise() throws InitialisationException {
        boolean bl = this.usesCachedStrategy = !Boolean.parseBoolean(System.getProperty("mule.extensionsClient.disableCache"));
        if (this.usesCachedStrategy) {
            this.operationMessageProcessorCache = this.createCache();
        }
    }

    private Cache<String, OperationMessageProcessor> createCache() {
        return Caffeine.newBuilder().maximumSize((long)MAX_CACHE_SIZE).expireAfterAccess((long)CACHE_ENTRY_EXPIRE_AFTER_ACCESS_IN_MINUTES, TimeUnit.MINUTES).removalListener((key, operationMessageProcessor, removalCause) -> OperationMessageProcessorUtils.disposeProcessor(operationMessageProcessor)).build();
    }

    @Override
    public void dispose() {
        if (this.operationMessageProcessorCache != null) {
            this.operationMessageProcessorCache.invalidateAll();
        }
    }
}

