/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.oauth.internal;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.oauth.api.ClientCredentialsOAuthDancer;
import org.mule.runtime.oauth.api.builder.ClientCredentialsListener;
import org.mule.runtime.oauth.api.builder.ClientCredentialsLocation;
import org.mule.runtime.oauth.api.exception.RequestAuthenticationException;
import org.mule.runtime.oauth.api.exception.TokenNotFoundException;
import org.mule.runtime.oauth.api.exception.TokenUrlResponseException;
import org.mule.runtime.oauth.api.state.DefaultResourceOwnerOAuthContext;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.service.oauth.internal.AbstractOAuthDancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientCredentialsOAuthDancer
extends AbstractOAuthDancer
implements Startable,
ClientCredentialsOAuthDancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClientCredentialsOAuthDancer.class);
    private boolean accessTokenRefreshedOnStart = false;
    private MultiMap<String, String> customParameters;
    private MultiMap<String, String> customHeaders;
    private final List<ClientCredentialsListener> listeners;
    private volatile CompletableFuture<Void> lastRefreshTokenFuture;
    private Lock refreshTokenLock;

    public DefaultClientCredentialsOAuthDancer(String clientId, String clientSecret, String tokenUrl, String scopes, ClientCredentialsLocation clientCredentialsLocation, Charset encoding, String responseAccessTokenExpr, String responseRefreshTokenExpr, String responseExpiresInExpr, Map<String, String> customParametersExprs, Function<String, String> resourceOwnerIdTransformer, LockFactory lockProvider, Map<String, DefaultResourceOwnerOAuthContext> tokensStore, HttpClient httpClient, MuleExpressionLanguage expressionEvaluator, MultiMap<String, String> customParameters, MultiMap<String, String> customHeaders, List<ClientCredentialsListener> listeners) {
        super(clientId, clientSecret, tokenUrl, encoding, scopes, clientCredentialsLocation, responseAccessTokenExpr, responseRefreshTokenExpr, responseExpiresInExpr, customParametersExprs, resourceOwnerIdTransformer, lockProvider, tokensStore, httpClient, expressionEvaluator);
        this.customParameters = customParameters;
        this.customHeaders = customHeaders;
        this.listeners = listeners != null ? new CopyOnWriteArrayList<ClientCredentialsListener>(listeners) : new CopyOnWriteArrayList<ClientCredentialsListener>();
    }

    @Override
    public void start() throws MuleException {
        super.start();
        this.refreshTokenLock = new ReentrantLock();
        try {
            this.refreshToken().get();
            this.accessTokenRefreshedOnStart = true;
        }
        catch (ExecutionException e) {
            if (!(e.getCause() instanceof TokenUrlResponseException) && !(e.getCause() instanceof TokenNotFoundException)) {
                super.stop();
                throw new LifecycleException(e.getCause(), (Object)this);
            }
        }
        catch (InterruptedException e) {
            super.stop();
            Thread.currentThread().interrupt();
            throw new LifecycleException(e, (Object)this);
        }
    }

    @Override
    public CompletableFuture<String> accessToken() throws RequestAuthenticationException {
        if (!this.accessTokenRefreshedOnStart) {
            this.accessTokenRefreshedOnStart = true;
            return this.refreshToken().thenApply(v -> this.getContext().getAccessToken());
        }
        String accessToken = this.getContext().getAccessToken();
        if (accessToken == null) {
            LOGGER.info("Previously stored token has been invalidated. Refreshing...");
            return this.doRefreshToken(false).thenApply(v -> this.getContext().getAccessToken());
        }
        return CompletableFuture.completedFuture(accessToken);
    }

    @Override
    public CompletableFuture<Void> refreshToken() {
        return this.doRefreshToken(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> doRefreshToken(boolean notifyListeners) {
        if (this.refreshTokenLock.tryLock()) {
            try {
                CompletableFuture<Void> completableFuture = this.lastRefreshTokenFuture = this.doRefreshTokenRequest(notifyListeners);
                return completableFuture;
            }
            finally {
                this.refreshTokenLock.unlock();
            }
        }
        this.refreshTokenLock.lock();
        try {
            CompletableFuture<Void> completableFuture = this.lastRefreshTokenFuture;
            return completableFuture;
        }
        finally {
            this.refreshTokenLock.unlock();
        }
    }

    private CompletableFuture<Void> doRefreshTokenRequest(boolean notifyListeners) {
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("grant_type", "client_credentials");
        if (this.scopes != null) {
            formData.put("scope", this.scopes);
        }
        String authorization = this.handleClientCredentials(formData);
        return this.invokeTokenUrl(this.tokenUrl, formData, this.customParameters, this.customHeaders, authorization, false, this.encoding).thenAccept(tokenResponse -> ClassUtils.withContextClassLoader(DefaultClientCredentialsOAuthDancer.class.getClassLoader(), () -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Retrieved access token, refresh token and expires from token url are: %s, %s, %s", new Object[]{tokenResponse.getAccessToken(), tokenResponse.getRefreshToken(), tokenResponse.getExpiresIn()});
            }
            DefaultResourceOwnerOAuthContext defaultUserState = (DefaultResourceOwnerOAuthContext)this.getContext();
            defaultUserState.setAccessToken(tokenResponse.getAccessToken());
            defaultUserState.setExpiresIn(tokenResponse.getExpiresIn());
            for (Map.Entry<String, Object> customResponseParameterEntry : tokenResponse.getCustomResponseParameters().entrySet()) {
                defaultUserState.getTokenResponseParameters().put(customResponseParameterEntry.getKey(), customResponseParameterEntry.getValue());
            }
            this.updateResourceOwnerOAuthContext(defaultUserState);
            if (notifyListeners) {
                this.listeners.forEach(l -> l.onTokenRefreshed(defaultUserState));
            }
        }));
    }

    @Override
    public void addListener(ClientCredentialsListener listener) {
        Preconditions.checkArgument(listener != null, "Cannot add a null listener");
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ClientCredentialsListener listener) {
        Preconditions.checkArgument(listener != null, "Cannot remove a null listener");
        this.listeners.remove(listener);
    }

    @Override
    public void invalidateContext() {
        this.invalidateContext("default");
    }

    @Override
    public ResourceOwnerOAuthContext getContext() {
        return this.getContextForResourceOwner("default");
    }
}

