/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.xml.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.mule.apache.xerces.dom.DOMInputImpl;
import org.mule.apache.xerces.impl.xs.SchemaSymbols;
import org.mule.apache.xerces.impl.xs.XSImplementationImpl;
import org.mule.apache.xerces.impl.xs.XSLoaderImpl;
import org.mule.apache.xerces.impl.xs.opti.SchemaDOMParser;
import org.mule.apache.xerces.impl.xs.opti.SchemaParsingConfig;
import org.mule.apache.xerces.impl.xs.util.LSInputListImpl;
import org.mule.apache.xerces.util.DOMEntityResolverWrapper;
import org.mule.apache.xerces.util.DOMUtil;
import org.mule.apache.xerces.xni.parser.XMLInputSource;
import org.mule.apache.xerces.xs.XSLoader;
import org.mule.apache.xerces.xs.XSModel;
import org.mule.metadata.api.annotation.ExampleAnnotation;
import org.mule.metadata.internal.utils.StringUtils;
import org.mule.metadata.xml.api.ModelFactoryFromExampleSupport;
import org.mule.metadata.xml.api.utils.SchemaHelper;
import org.mule.metadata.xml.api.utils.XmlSchemaUtils;
import org.mule.metadata.xml.internal.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.LSInput;

public class ModelFactory {
    private static final String EXPAND_ENTITIES_PROPERTY = "mule.xml.expandInternalEntities";
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelFactory.class);
    private XSModel model;
    private Optional<QName> rootElementName;
    private Optional<ExampleAnnotation> example;

    private ModelFactory(XSModel model, ExampleAnnotation example, QName rootElementName) {
        this.model = model;
        this.example = Optional.ofNullable(example);
        this.rootElementName = Optional.ofNullable(rootElementName);
    }

    public static ModelFactory fromExample(File exampleFile) {
        try {
            return ModelFactory.fromExample(Files.readAllLines(exampleFile.toPath()).stream().collect(Collectors.joining()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ModelFactory fromExample(String exampleXML) {
        List<String> schemas;
        XSLoader schemaLoader;
        try {
            schemaLoader = ModelFactory.initializeXSLoader();
            schemas = SchemaHelper.generateXSD(exampleXML);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generated XSD schemas.", e);
        }
        if (schemas.size() > 1) {
            try {
                schemas = ModelFactoryFromExampleSupport.fixForMultipleSchemas(schemaLoader, schemas);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to configure XSD loader.", e);
            }
        }
        try {
            LSInput[] domInputs = (DOMInputImpl[])schemas.stream().map(schema -> new DOMInputImpl(null, null, null, new StringReader((String)schema), "UTF-8")).toArray(DOMInputImpl[]::new);
            XSModel model = schemaLoader.loadInputList(new LSInputListImpl(domInputs, domInputs.length));
            Optional<QName> rootElementName = XmlSchemaUtils.getXmlSchemaRootElementName(schemas, exampleXML);
            return new ModelFactory(model, new ExampleAnnotation(StringEscapeUtils.escapeXml11((String)exampleXML)), rootElementName.orElse(null));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate metadatatype from XSD.", e);
        }
    }

    public static ModelFactory fromSchemas(Map<String, InputStream> schemasMap) {
        try {
            XSLoaderImpl schemaLoader = (XSLoaderImpl)ModelFactory.initializeXSLoader();
            Map<String, List<DOMInputImpl>> schemaByTargetNamespace = ModelFactory.getSchemasByTargetNamespace(schemasMap);
            ResourceResolver resourceResolver = new ResourceResolver(schemaByTargetNamespace);
            schemaLoader.setParameter("http://apache.org/xml/properties/internal/entity-resolver", new DOMEntityResolverWrapper(resourceResolver));
            ArrayList errors = new ArrayList();
            String expandEntitiesValue = System.getProperty(EXPAND_ENTITIES_PROPERTY, "false");
            schemaLoader.setParameter("http://apache.org/xml/features/disallow-doctype-decl", !Boolean.parseBoolean(expandEntitiesValue));
            schemaLoader.setParameter("http://apache.org/xml/features/honour-all-schemaLocations", true);
            schemaLoader.setParameter("error-handler", error -> {
                errors.add(error.getMessage());
                return false;
            });
            LSInput[] domInputs = resourceResolver.getSchemaArray();
            XSModel model = schemaLoader.loadInputList(new LSInputListImpl(domInputs, domInputs.length));
            if (model == null) {
                throw new RuntimeException("Failed while trying to load schema errors " + errors.stream().reduce("", (value, acc) -> value + ", " + acc));
            }
            return new ModelFactory(model, null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, List<DOMInputImpl>> getSchemasByTargetNamespace(Map<String, InputStream> schemasMap) throws IOException {
        SchemaDOMParser schemaDOMParser = new SchemaDOMParser(new SchemaParsingConfig());
        LinkedHashMap<String, List<DOMInputImpl>> schemaByTargetNamespace = new LinkedHashMap<String, List<DOMInputImpl>>();
        int i = 0;
        for (Map.Entry<String, InputStream> schema : schemasMap.entrySet()) {
            String key;
            String schemaString = IOUtils.toString((InputStream)schema.getValue(), (String)"UTF-8");
            DOMInputImpl domInput = new DOMInputImpl(null, schema.getKey(), null, schemaString, "UTF-8");
            String targetNamespace = ModelFactory.getTargetNamespace(schema.getKey(), schemaString, schemaDOMParser);
            String string = key = StringUtils.isNotEmpty(targetNamespace) ? targetNamespace : "NO_NAMESPACE_" + i++;
            if (!schemaByTargetNamespace.containsKey(key)) {
                schemaByTargetNamespace.put(key, new LinkedList());
            }
            ((List)schemaByTargetNamespace.get(key)).add(domInput);
        }
        return schemaByTargetNamespace;
    }

    private static String getTargetNamespace(String systemId, String schema, SchemaDOMParser domParser) {
        try {
            domParser.parse(new XMLInputSource(null, systemId, null, new StringReader(schema), "UTF-8"));
        }
        catch (IOException e) {
            LOGGER.error("Error getting namespace from schema: " + e.getMessage(), (Throwable)e);
            return null;
        }
        Document document = domParser.getDocument();
        Element element = document != null ? DOMUtil.getRoot(document) : null;
        return DOMUtil.getAttrValue(element, SchemaSymbols.ATT_TARGETNAMESPACE);
    }

    private static XSLoader initializeXSLoader() {
        XSImplementationImpl impl = new XSImplementationImpl();
        return impl.createXSLoader(null);
    }

    XSModel getModel() {
        return this.model;
    }

    public Optional<QName> getRootElementName() {
        return this.rootElementName;
    }

    public Optional<ExampleAnnotation> getExample() {
        return this.example;
    }
}

