/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.service.server.grizzly.BaseResponseCompletionHandler;
import org.mule.service.http.impl.service.server.grizzly.HttpMultipartEncoder;

public class ResponseCompletionHandler
extends BaseResponseCompletionHandler {
    private final FilterChainContext ctx;
    private final ClassLoader ctxClassLoader;
    private final HttpResponsePacket httpResponsePacket;
    private final HttpContent httpResponseContent;
    private final ResponseStatusCallback responseStatusCallback;
    private final Protocol protocol;
    private boolean isDone;
    private boolean contentSend;

    public ResponseCompletionHandler(FilterChainContext ctx, ClassLoader ctxClassLoader, HttpRequestPacket httpRequestPacket, HttpResponse httpResponse, ResponseStatusCallback responseStatusCallback) {
        Preconditions.checkArgument(!httpResponse.getEntity().isStreaming(), "HTTP response entity cannot be stream based");
        this.ctx = ctx;
        this.ctxClassLoader = ctxClassLoader;
        this.protocol = httpRequestPacket.getProtocol();
        this.httpResponsePacket = this.buildHttpResponsePacket(httpRequestPacket, httpResponse);
        this.httpResponseContent = this.buildResponseContent(httpResponse);
        this.responseStatusCallback = responseStatusCallback;
    }

    public HttpContent buildResponseContent(HttpResponse httpResponse) {
        HttpEntity body2 = httpResponse.getEntity();
        Buffer grizzlyBuffer = null;
        if (body2 != null) {
            byte[] bytes;
            if (body2.isComposed()) {
                try {
                    bytes = HttpMultipartEncoder.toByteArray(body2, this.httpResponsePacket.getHeader("Content-Type"));
                }
                catch (IOException e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Error sending multipart response"), (Throwable)e);
                }
            }
            try {
                bytes = body2.getBytes();
            }
            catch (IOException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Error sending response"), (Throwable)e);
            }
            if (!(this.protocol.equals((Object)Protocol.HTTP_1_0) || this.httpResponsePacket.isChunked() || this.hasContentLength)) {
                this.httpResponsePacket.setContentLength(bytes.length);
            }
            grizzlyBuffer = Buffers.wrap((MemoryManager)this.ctx.getMemoryManager(), (byte[])bytes);
        }
        HttpContent.Builder contentBuilder = HttpContent.builder((HttpHeader)this.httpResponsePacket);
        if (this.hasContentLength || this.httpResponsePacket.getContentLength() > 0L) {
            contentBuilder.last(true);
        }
        return contentBuilder.content(grizzlyBuffer).build();
    }

    public void start() throws IOException {
        this.sendResponse();
    }

    public void sendResponse() throws IOException {
        if (!this.contentSend) {
            this.contentSend = true;
            this.isDone = this.httpResponsePacket.getRequest().getMethod().equals(Method.HEAD) || !this.httpResponsePacket.isChunked();
            this.ctx.write((Object)this.httpResponseContent, (CompletionHandler)this);
            return;
        }
        this.isDone = true;
        this.ctx.write((Object)this.httpResponsePacket.httpTrailerBuilder().build(), (CompletionHandler)this);
    }

    public void completed(WriteResult result) {
        try {
            if (!this.isDone) {
                this.sendResponse();
            } else {
                this.doComplete();
            }
        }
        catch (IOException e) {
            this.failed(e);
        }
    }

    private void doComplete() {
        this.ctx.notifyDownstream(HttpServerFilter.RESPONSE_COMPLETE_EVENT);
        this.responseStatusCallback.responseSendSuccessfully();
        this.resume();
    }

    @Override
    public void cancelled() {
        super.cancelled();
        this.responseStatusCallback.responseSendFailure(new Exception("http response transferring cancelled"));
        this.resume();
    }

    @Override
    public void failed(Throwable throwable) {
        super.failed(throwable);
        this.responseStatusCallback.onErrorSendingResponse(throwable);
        this.resume();
    }

    private void resume() {
        this.ctx.resume(this.ctx.getStopAction());
    }

    @Override
    protected ClassLoader getCtxClassLoader() {
        return this.ctxClassLoader;
    }
}

