/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.reduced;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

class CatalogTypeCollectorMetadataTypeVisitor
extends MetadataTypeVisitor {
    private final Map<String, ObjectType> registeredTypes = new HashMap<String, ObjectType>();

    CatalogTypeCollectorMetadataTypeVisitor() {
    }

    @Override
    public void visitObject(ObjectType type) {
        Optional<String> typeId = MetadataTypeUtils.getTypeId(type);
        if (typeId.isPresent()) {
            String id = typeId.get();
            if (this.registeredTypes.containsKey(id)) {
                return;
            }
            this.registeredTypes.put(id, type);
        }
        type.getOpenRestriction().ifPresent(t -> t.accept(this));
        type.getFields().forEach(field -> field.getValue().accept(this));
    }

    @Override
    public void visitArrayType(ArrayType arrayType) {
        arrayType.getType().accept(this);
    }

    @Override
    public void visitFunction(FunctionType functionType) {
        functionType.getParameters().forEach(p -> p.getType().accept(this));
        functionType.getReturnType().ifPresent(rt -> rt.accept(this));
    }

    @Override
    public void visitIntersection(IntersectionType intersectionType) {
        intersectionType.getTypes().forEach(t -> t.accept(this));
    }

    @Override
    public void visitUnion(UnionType unionType) {
        unionType.getTypes().forEach(t -> t.accept(this));
    }

    public Map<String, ObjectType> getCatalog() {
        return ImmutableMap.copyOf(this.registeredTypes);
    }
}

