/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.reduced;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;
import org.mule.metadata.persistence.reduced.CatalogJsonMetadataTypeLoader;

class MetadataTypeCatalogLoader {
    MetadataTypeCatalogLoader() {
    }

    static Map<String, MetadataType> loadCatalog(JsonObject jsonCatalog) {
        HashMap catalog = new HashMap();
        HashMap stack = new HashMap();
        jsonCatalog.entrySet().forEach(e -> MetadataTypeCatalogLoader.loadEntry(catalog, stack, jsonCatalog, (String)e.getKey()));
        return catalog.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TypeBuilder)e.getValue()).build()));
    }

    private static TypeBuilder loadEntry(final Map<String, TypeBuilder> catalog, final Map<String, TypeBuilder> stack, final JsonObject jsonCatalog, String key) {
        Optional<TypeBuilder> loadedBuilder;
        if (catalog.containsKey(key)) {
            return catalog.get(key);
        }
        CatalogJsonMetadataTypeLoader loader = new CatalogJsonMetadataTypeLoader(new ObjectTypeReferenceHandler(){

            @Override
            public Optional<String> writeReference(ObjectType type, JsonWriter writer) {
                return Optional.empty();
            }

            @Override
            public Optional<TypeBuilder> readReference(String typeRef) {
                if (typeRef.startsWith("@ref:")) {
                    String id = typeRef.replace("@ref:", "");
                    if (stack.containsKey(id)) {
                        return Optional.ofNullable(stack.get(id));
                    }
                    TypeBuilder metadataType = MetadataTypeCatalogLoader.loadEntry(catalog, stack, jsonCatalog, id);
                    return Optional.of(metadataType);
                }
                return Optional.empty();
            }
        });
        JsonElement catalogTypeElement = jsonCatalog.get(key);
        if (catalogTypeElement != null && (loadedBuilder = loader.load(catalogTypeElement, stack)).isPresent()) {
            TypeBuilder typeBuilder = loadedBuilder.get();
            catalog.put(key, typeBuilder);
            return typeBuilder;
        }
        throw new RuntimeException("Element [" + key + "] not found in catalog");
    }
}

