/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.exception.ErrorMapping;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.internal.policy.FlowExecutionException;
import org.mule.runtime.core.internal.util.InternalExceptionUtils;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;

public class MessagingExceptionResolver {
    private final Component component;

    public MessagingExceptionResolver(Component component) {
        this.component = component;
    }

    @Deprecated
    public MessagingException resolve(MessagingException me, MuleContext context) {
        return this.resolve(me, ((PrivilegedMuleContext)context).getErrorTypeLocator(), context.getExceptionContextProviders());
    }

    public MessagingException resolve(MessagingException me, ErrorTypeLocator locator, Collection<ExceptionContextProvider> exceptionContextProviders) {
        MessagingException result;
        Optional<Pair<Throwable, ErrorType>> rootCause = this.findRoot(this.component, me, locator);
        if (!rootCause.isPresent()) {
            return this.updateCurrent(me, this.component, locator, exceptionContextProviders);
        }
        Throwable root = rootCause.get().getFirst();
        ErrorType rootErrorType = rootCause.get().getSecond();
        Component failingComponent = this.getFailingProcessor(me, root).orElse(this.component);
        ErrorType errorType = InternalExceptionUtils.getErrorMappings(this.component).stream().filter(m -> m.match(rootErrorType)).findFirst().map(ErrorMapping::getTarget).orElse(rootErrorType);
        Error error = ErrorBuilder.builder(ExceptionUtils.getMessagingExceptionCause(root)).errorType(errorType).build();
        CoreEvent event = CoreEvent.builder(me.getEvent()).error(error).build();
        if (root instanceof MessagingException) {
            ((MessagingException)root).setProcessedEvent(event);
            result = (MessagingException)root;
        } else {
            result = me instanceof FlowExecutionException ? new FlowExecutionException(event, root, failingComponent) : new MessagingException(event, root, failingComponent);
        }
        this.propagateAlreadyLogged(me, result);
        return this.enrich(result, failingComponent, this.component, event, exceptionContextProviders);
    }

    private void propagateAlreadyLogged(MessagingException origin, MuleException result) {
        if (origin.getInfo().containsKey("Logged")) {
            result.addInfo("Logged", origin.getInfo().get("Logged"));
        }
    }

    private Optional<Pair<Throwable, ErrorType>> findRoot(Component obj, MessagingException me, ErrorTypeLocator locator) {
        List<Pair<Throwable, ErrorType>> errors = this.collectErrors(obj, me, locator);
        if (errors.isEmpty()) {
            return this.collectCritical(obj, me, locator).stream().findFirst();
        }
        SingleErrorTypeMatcher matcher = new SingleErrorTypeMatcher(errors.get(0).getSecond());
        Reference result = new Reference();
        errors.forEach(p -> {
            if (matcher.match((ErrorType)p.getSecond())) {
                result.set(p);
            }
        });
        return Optional.ofNullable(result.get());
    }

    private List<Pair<Throwable, ErrorType>> collectErrors(Component obj, MessagingException me, ErrorTypeLocator locator) {
        LinkedList<Pair<Throwable, ErrorType>> errors = new LinkedList<Pair<Throwable, ErrorType>>();
        ExceptionHelper.getExceptionsAsList(me).forEach(e -> {
            ErrorType type = this.errorTypeFromException(obj, locator, (Throwable)e);
            if (!ExceptionUtils.isUnknownMuleError(type) && !this.isCriticalMuleError(type)) {
                errors.add(new Pair<Throwable, ErrorType>((Throwable)e, type));
            }
        });
        return errors;
    }

    private List<Pair<Throwable, ErrorType>> collectCritical(Component obj, MessagingException me, ErrorTypeLocator locator) {
        LinkedList<Pair<Throwable, ErrorType>> errors = new LinkedList<Pair<Throwable, ErrorType>>();
        ExceptionHelper.getExceptionsAsList(me).forEach(e -> {
            ErrorType type = this.errorTypeFromException(obj, locator, (Throwable)e);
            if (this.isCriticalMuleError(type)) {
                errors.add(new Pair<Throwable, ErrorType>((Throwable)e, type));
            }
        });
        return errors;
    }

    private MessagingException updateCurrent(MessagingException me, Component processor, ErrorTypeLocator locator, Collection<ExceptionContextProvider> exceptionContextProviders) {
        CoreEvent errorEvent = InternalExceptionUtils.createErrorEvent(me.getEvent(), processor, me, locator);
        Component failingProcessor = me.getFailingComponent() != null ? me.getFailingComponent() : processor;
        MessagingException updated = me instanceof FlowExecutionException ? new FlowExecutionException(errorEvent, me.getCause(), failingProcessor) : new MessagingException(me.getI18nMessage(), errorEvent, me.getCause(), failingProcessor);
        return this.enrich(updated, failingProcessor, processor, errorEvent, exceptionContextProviders);
    }

    private Optional<Component> getFailingProcessor(MessagingException me, Throwable root) {
        Component failing = me.getFailingComponent();
        if (failing == null && root instanceof MessagingException) {
            failing = ((MessagingException)root).getFailingComponent();
        }
        return Optional.ofNullable(failing);
    }

    private ErrorType errorTypeFromException(Component failing, ErrorTypeLocator locator, Throwable e) {
        if (this.isMessagingExceptionWithError(e)) {
            return ((MessagingException)e).getEvent().getError().map(Error::getErrorType).orElse(locator.lookupErrorType(e));
        }
        Optional<ComponentIdentifier> componentIdentifier = ExceptionUtils.getComponentIdentifier(failing);
        return componentIdentifier.map(ci -> locator.lookupComponentErrorType((ComponentIdentifier)ci, e)).orElse(locator.lookupErrorType(e));
    }

    private boolean isMessagingExceptionWithError(Throwable cause) {
        return cause instanceof MessagingException && ((MessagingException)cause).getEvent().getError().isPresent();
    }

    private <T extends MuleException> T enrich(T me, Component failing, Component handling, CoreEvent event, Collection<ExceptionContextProvider> exceptionContextProviders) {
        EnrichedNotificationInfo notificationInfo = EnrichedNotificationInfo.createInfo(event, me, null);
        exceptionContextProviders.forEach(cp -> cp.getContextInfo(notificationInfo, failing).forEach((k, v) -> me.getInfo().putIfAbsent((String)k, v)));
        return me;
    }

    private boolean isCriticalMuleError(ErrorType type) {
        return type.getNamespace().equals(Errors.CORE_NAMESPACE_NAME) && type.getIdentifier().equals("CRITICAL");
    }
}

